"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetProjectTagsRoute = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerGetProjectTagsRoute = (router, {
  logger
}) => {
  router.get({
    path: '/internal/cps/projects_tags',
    validate: false,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    }
  }, async (requestHandlerContext, request, response) => {
    try {
      const core = await requestHandlerContext.core;
      const result = await core.elasticsearch.client.asCurrentUser.transport.request({
        method: 'GET',
        path: `/_project/tags`
      });
      return response.ok({
        body: result
      });
    } catch (error) {
      logger.get().debug(error);
      throw error;
    }
  });
};
exports.registerGetProjectTagsRoute = registerGetProjectTagsRoute;