"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CpsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18nReact = require("@kbn/i18n-react");
var _cps_manager = require("./services/cps_manager");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/cps/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CpsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "initializerContext", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core) {
    const {
      cpsEnabled
    } = this.initializerContext.config.get();
    return {
      cpsEnabled
    };
  }
  start(core) {
    const {
      cpsEnabled
    } = this.initializerContext.config.get();
    let cpsManager;

    // Only initialize cpsManager in serverless environments when CPS is enabled
    if (cpsEnabled) {
      const manager = new _cps_manager.CPSManager({
        http: core.http,
        logger: this.initializerContext.logger.get('cps'),
        application: core.application
      });

      // Register project picker in the navigation
      Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/cps-utils'))).then(({
        ProjectPickerContainer
      }) => {
        core.chrome.navControls.registerLeft({
          mount: element => {
            _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 50,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement(ProjectPickerContainer, {
              cpsManager: manager,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 51,
                columnNumber: 17
              }
            })), element, () => {});
            return () => {
              _reactDom.default.unmountComponentAtNode(element);
            };
          },
          order: 1000
        });
      });
      cpsManager = manager;
    }
    return {
      cpsManager
    };
  }
  stop() {}
}
exports.CpsPlugin = CpsPlugin;