"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApplicationService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _history = require("history");
var _coreCapabilitiesBrowserInternal = require("@kbn/core-capabilities-browser-internal");
var _coreApplicationBrowser = require("@kbn/core-application-browser");
var _ui = require("./ui");
var _application_leave = require("./application_leave");
var _navigation_confirm = require("./navigation_confirm");
var _utils = require("./utils");
var _register_analytics_context_provider = require("./register_analytics_context_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/application/browser-internal/src/application_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function filterAvailable(m, capabilities) {
  return new Map([...m].filter(([id]) => capabilities.navLinks[id] === undefined || capabilities.navLinks[id] === true));
}
const findMounter = (mounters, appRoute) => [...mounters].find(([, mounter]) => mounter.appRoute === appRoute);
const getAppUrl = (mounters, appId, path = '') => {
  var _mounters$get;
  const appBasePath = (_mounters$get = mounters.get(appId)) !== null && _mounters$get !== void 0 && _mounters$get.appRoute ? `/${mounters.get(appId).appRoute}` : `/app/${appId}`;
  return (0, _utils.appendAppPath)(appBasePath, path);
};
const getAppDeepLinkPath = (app, appId, deepLinkId) => {
  const flattenedLinks = flattenDeepLinks(app.deepLinks);
  return flattenedLinks[deepLinkId];
};
const applicationIdRegexp = /^[a-zA-Z0-9_:-]+$/;
const allApplicationsFilter = '__ALL__';
/**
 * Service that is responsible for registering new applications.
 * @internal
 */
class ApplicationService {
  constructor() {
    (0, _defineProperty2.default)(this, "apps", new Map());
    (0, _defineProperty2.default)(this, "mounters", new Map());
    (0, _defineProperty2.default)(this, "capabilities", new _coreCapabilitiesBrowserInternal.CapabilitiesService());
    (0, _defineProperty2.default)(this, "appInternalStates", new Map());
    (0, _defineProperty2.default)(this, "currentAppId$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "currentActionMenu$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "statusUpdaters$", new _rxjs.BehaviorSubject(new Map()));
    (0, _defineProperty2.default)(this, "subscriptions", []);
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "registrationClosed", false);
    (0, _defineProperty2.default)(this, "history", void 0);
    (0, _defineProperty2.default)(this, "location$", void 0);
    (0, _defineProperty2.default)(this, "navigate", void 0);
    (0, _defineProperty2.default)(this, "openInNewTab", void 0);
    (0, _defineProperty2.default)(this, "redirectTo", void 0);
    (0, _defineProperty2.default)(this, "overlayStart$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "hasCustomBranding$", void 0);
    (0, _defineProperty2.default)(this, "setAppLeaveHandler", (appId, handler) => {
      var _this$appInternalStat;
      this.appInternalStates.set(appId, {
        ...((_this$appInternalStat = this.appInternalStates.get(appId)) !== null && _this$appInternalStat !== void 0 ? _this$appInternalStat : {}),
        leaveHandler: handler
      });
    });
    (0, _defineProperty2.default)(this, "setAppActionMenu", (appId, mount) => {
      var _this$appInternalStat2;
      this.appInternalStates.set(appId, {
        ...((_this$appInternalStat2 = this.appInternalStates.get(appId)) !== null && _this$appInternalStat2 !== void 0 ? _this$appInternalStat2 : {}),
        actionMenu: mount
      });
      this.refreshCurrentActionMenu();
    });
    (0, _defineProperty2.default)(this, "refreshCurrentActionMenu", () => {
      var _this$appInternalStat3;
      const appId = this.currentAppId$.getValue();
      const currentActionMenu = appId ? (_this$appInternalStat3 = this.appInternalStates.get(appId)) === null || _this$appInternalStat3 === void 0 ? void 0 : _this$appInternalStat3.actionMenu : undefined;
      this.currentActionMenu$.next(currentActionMenu);
    });
    (0, _defineProperty2.default)(this, "onBeforeUnload", event => {
      var _this$appInternalStat4;
      const currentAppId = this.currentAppId$.value;
      if (currentAppId === undefined) {
        return;
      }
      const action = (0, _application_leave.getLeaveAction)((_this$appInternalStat4 = this.appInternalStates.get(currentAppId)) === null || _this$appInternalStat4 === void 0 ? void 0 : _this$appInternalStat4.leaveHandler);
      if ((0, _application_leave.isConfirmAction)(action)) {
        event.preventDefault();
        // some browsers accept a string return value being the message displayed
        event.returnValue = action.text;
      }
    });
  }
  setup({
    http: {
      basePath
    },
    analytics,
    redirectTo = path => {
      window.location.assign(path);
    },
    history
  }) {
    const basename = basePath.get();
    this.history = history || (0, _history.createBrowserHistory)({
      basename,
      getUserConfirmation: (0, _navigation_confirm.getUserConfirmationHandler)({
        overlayPromise: (0, _rxjs.firstValueFrom)(this.overlayStart$.pipe((0, _rxjs.take)(1)))
      })
    });
    this.location$ = (0, _utils.getLocationObservable)(window.location, this.history);
    (0, _register_analytics_context_provider.registerAnalyticsContextProvider)({
      analytics,
      location$: this.location$
    });
    this.navigate = (url, state, replace) => {
      // basePath not needed here because `history` is configured with basename
      return replace ? this.history.replace(url, state) : this.history.push(url, state);
    };
    this.openInNewTab = url => {
      // window.open shares session information if base url is same
      return window.open((0, _utils.appendAppPath)(basename, url), '_blank');
    };
    this.redirectTo = redirectTo;
    const registerStatusUpdater = (application, updater$) => {
      const updaterId = Symbol();
      const subscription = updater$.subscribe(updater => {
        const nextValue = new Map(this.statusUpdaters$.getValue());
        nextValue.set(updaterId, {
          application,
          updater
        });
        this.statusUpdaters$.next(nextValue);
      });
      this.subscriptions.push(subscription);
    };
    const wrapMount = (plugin, app) => {
      return async params => {
        const currentAppId = this.currentAppId$.value;
        if (currentAppId && currentAppId !== app.id) {
          this.appInternalStates.delete(currentAppId);
        }
        this.currentAppId$.next(app.id);
        return app.mount(params);
      };
    };
    const validateApp = app => {
      if (this.registrationClosed) {
        throw new Error(`Applications cannot be registered after "setup" (attempted to register "${app.id}")`);
      } else if (!applicationIdRegexp.test(app.id)) {
        throw new Error(`Invalid application id: it can only be composed of alphanum chars, '-' and '_'`);
      } else if (this.apps.has(app.id)) {
        throw new Error(`An application is already registered with the id "${app.id}"`);
      } else if (findMounter(this.mounters, app.appRoute)) {
        throw new Error(`An application is already registered with the appRoute "${app.appRoute}"`);
      } else if (basename && app.appRoute.startsWith(`${basename}/`)) {
        throw new Error('Cannot register an application route that includes HTTP base path');
      }
    };
    return {
      register: (plugin, app) => {
        var _app$status, _app$exactRoute;
        app = {
          appRoute: `/app/${app.id}`,
          ...app
        };
        validateApp(app);
        const {
          updater$,
          ...appProps
        } = app;
        this.apps.set(app.id, {
          ...appProps,
          status: (_app$status = app.status) !== null && _app$status !== void 0 ? _app$status : _coreApplicationBrowser.AppStatus.accessible,
          deepLinks: populateDeepLinkDefaults(appProps.deepLinks)
        });
        if (updater$) {
          registerStatusUpdater(app.id, updater$);
        }
        this.mounters.set(app.id, {
          appRoute: app.appRoute,
          appBasePath: basePath.prepend(app.appRoute),
          exactRoute: (_app$exactRoute = app.exactRoute) !== null && _app$exactRoute !== void 0 ? _app$exactRoute : false,
          mount: wrapMount(plugin, app),
          unmountBeforeMounting: false
        });
      },
      registerAppUpdater: appUpdater$ => registerStatusUpdater(allApplicationsFilter, appUpdater$)
    };
  }
  async start({
    analytics,
    http,
    overlays,
    theme,
    customBranding
  }) {
    if (!this.redirectTo) {
      throw new Error('ApplicationService#setup() must be invoked before start.');
    }
    this.overlayStart$.next(overlays);
    this.hasCustomBranding$ = customBranding.hasCustomBranding$.pipe((0, _rxjs.takeUntil)(this.stop$));
    const httpLoadingCount$ = new _rxjs.BehaviorSubject(0);
    http.addLoadingCountSource(httpLoadingCount$);
    this.registrationClosed = true;
    window.addEventListener('beforeunload', this.onBeforeUnload);
    const {
      capabilities
    } = await this.capabilities.start({
      appIds: [...this.mounters.keys()],
      http
    });
    const availableMounters = filterAvailable(this.mounters, capabilities);
    const availableApps = filterAvailable(this.apps, capabilities);
    const applications$ = new _rxjs.BehaviorSubject(availableApps);
    this.statusUpdaters$.pipe((0, _rxjs.map)(statusUpdaters => {
      return new Map([...availableApps].map(([id, app]) => [id, updateStatus(app, [...statusUpdaters.values()])]));
    })).subscribe(apps => applications$.next(apps));
    const applicationStatuses$ = applications$.pipe((0, _rxjs.map)(apps => new Map([...apps.entries()].map(([id, app]) => [id, app.status]))), (0, _rxjs.shareReplay)(1));
    const navigateToApp = async (appId, {
      deepLinkId,
      path,
      state,
      replace = false,
      openInNewTab = false,
      skipAppLeave = false
    } = {}) => {
      const currentAppId = this.currentAppId$.value;
      const navigatingToSameApp = currentAppId === appId;
      const shouldNavigate = navigatingToSameApp || skipAppLeave ? true : await this.shouldNavigate(overlays, appId);
      const targetApp = applications$.value.get(appId);
      if (shouldNavigate) {
        if (deepLinkId && targetApp) {
          const deepLinkPath = getAppDeepLinkPath(targetApp, appId, deepLinkId);
          if (deepLinkPath) {
            path = (0, _utils.appendAppPath)(deepLinkPath, path);
          }
        }
        if (path === undefined) {
          path = targetApp === null || targetApp === void 0 ? void 0 : targetApp.defaultPath;
        }
        if (openInNewTab) {
          this.openInNewTab(getAppUrl(availableMounters, appId, path));
        } else {
          this.navigate(getAppUrl(availableMounters, appId, path), state, replace);
        }
      }
    };
    this.currentAppId$.subscribe(() => this.refreshCurrentActionMenu());
    return {
      applications$: applications$.pipe((0, _rxjs.map)(apps => new Map([...apps.entries()].map(([id, app]) => [id, (0, _utils.getAppInfo)(app)]))), (0, _rxjs.shareReplay)(1)),
      capabilities,
      currentLocation$: this.location$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      currentAppId$: this.currentAppId$.pipe((0, _rxjs.filter)(appId => appId !== undefined), (0, _rxjs.distinctUntilChanged)(), (0, _rxjs.takeUntil)(this.stop$)),
      currentActionMenu$: this.currentActionMenu$.pipe((0, _rxjs.distinctUntilChanged)(), (0, _rxjs.takeUntil)(this.stop$)),
      history: this.history,
      isAppRegistered: appId => {
        return applications$.value.get(appId) !== undefined;
      },
      getUrlForApp: (appId, {
        path,
        absolute = false,
        deepLinkId
      } = {}) => {
        const targetApp = applications$.value.get(appId);
        if (deepLinkId && targetApp) {
          const deepLinkPath = getAppDeepLinkPath(targetApp, appId, deepLinkId);
          if (deepLinkPath) {
            path = (0, _utils.appendAppPath)(deepLinkPath, path);
          }
        }
        const relUrl = http.basePath.prepend(getAppUrl(availableMounters, appId, path));
        return absolute ? (0, _utils.relativeToAbsolute)(relUrl) : relUrl;
      },
      navigateToApp,
      navigateToUrl: async (url, {
        skipAppLeave = false,
        forceRedirect = false,
        state
      } = {}) => {
        const appInfo = (0, _utils.parseAppUrl)(url, http.basePath, this.apps);
        if ((forceRedirect || !appInfo) === true) {
          if (skipAppLeave) {
            window.removeEventListener('beforeunload', this.onBeforeUnload);
          }
          return this.redirectTo(url);
        }
        if (appInfo) {
          return navigateToApp(appInfo.app, {
            path: appInfo.path,
            skipAppLeave,
            state
          });
        }
      },
      getComponent: () => {
        if (!this.history) {
          return null;
        }
        return /*#__PURE__*/_react.default.createElement(_ui.AppRouter, {
          analytics: analytics,
          history: this.history,
          theme$: theme.theme$,
          mounters: availableMounters,
          appStatuses$: applicationStatuses$,
          setAppLeaveHandler: this.setAppLeaveHandler,
          setAppActionMenu: this.setAppActionMenu,
          setIsMounting: isMounting => httpLoadingCount$.next(isMounting ? 1 : 0),
          hasCustomBranding$: this.hasCustomBranding$,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 374,
            columnNumber: 11
          }
        });
      }
    };
  }
  async shouldNavigate(overlays, nextAppId) {
    var _this$appInternalStat5;
    const currentAppId = this.currentAppId$.value;
    if (currentAppId === undefined) {
      return true;
    }
    const action = (0, _application_leave.getLeaveAction)((_this$appInternalStat5 = this.appInternalStates.get(currentAppId)) === null || _this$appInternalStat5 === void 0 ? void 0 : _this$appInternalStat5.leaveHandler, nextAppId);
    if ((0, _application_leave.isConfirmAction)(action)) {
      const confirmed = await overlays.openConfirm(action.text, {
        title: action.title,
        'data-test-subj': 'appLeaveConfirmModal',
        confirmButtonText: action.confirmButtonText,
        buttonColor: action.buttonColor
      });
      if (!confirmed) {
        if (action.callback) {
          setTimeout(action.callback, 0);
        }
        return false;
      }
    }
    return true;
  }
  stop() {
    this.stop$.next();
    this.currentAppId$.complete();
    this.currentActionMenu$.complete();
    this.statusUpdaters$.complete();
    this.subscriptions.forEach(sub => sub.unsubscribe());
    window.removeEventListener('beforeunload', this.onBeforeUnload);
  }
}
exports.ApplicationService = ApplicationService;
const updateStatus = (app, statusUpdaters) => {
  let changes = {};
  statusUpdaters.forEach(wrapper => {
    if (wrapper.application !== allApplicationsFilter && wrapper.application !== app.id) {
      return;
    }
    const fields = wrapper.updater(app);
    if (fields) {
      var _changes$status, _fields$status;
      changes = {
        ...changes,
        ...fields,
        // status and navLinkStatus enums are ordered by reversed priority
        // if multiple updaters wants to change these fields, we will always follow the priority order.
        status: Math.max((_changes$status = changes.status) !== null && _changes$status !== void 0 ? _changes$status : _coreApplicationBrowser.AppStatus.accessible, (_fields$status = fields.status) !== null && _fields$status !== void 0 ? _fields$status : _coreApplicationBrowser.AppStatus.accessible),
        ...(fields.deepLinks ? {
          deepLinks: populateDeepLinkDefaults(fields.deepLinks)
        } : {})
      };
    }
  });
  return {
    ...app,
    ...changes
  };
};
const populateDeepLinkDefaults = deepLinks => {
  if (!deepLinks) {
    return [];
  }
  return deepLinks.map(deepLink => {
    var _deepLink$visibleIn;
    return {
      ...deepLink,
      visibleIn: (_deepLink$visibleIn = deepLink.visibleIn) !== null && _deepLink$visibleIn !== void 0 ? _deepLink$visibleIn : ['globalSearch'],
      // by default, deepLinks are only visible in global search.
      deepLinks: populateDeepLinkDefaults(deepLink.deepLinks)
    };
  });
};
const flattenDeepLinks = deepLinks => {
  if (!deepLinks) {
    return {};
  }
  return deepLinks.reduce((deepLinkPaths, deepLink) => {
    if (deepLink.path) deepLinkPaths[deepLink.id] = deepLink.path;
    return {
      ...deepLinkPaths,
      ...flattenDeepLinks(deepLink.deepLinks)
    };
  }, {});
};