"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateOtherFieldsKeys = exports.commonIncidentSchemaObjectProperties = exports.ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfigurationBaseSchema = exports.ExternalIncidentServiceConfigurationBase = exports.ExternalIncidentServiceConfiguration = exports.ExecutorSubActionHandshakeParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionGetChoicesParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = exports.ExecutorSubActionCloseIncidentParamsSchema = exports.CommonAttributes = exports.CommentsSchema = void 0;
var _zod = require("@kbn/zod");
var _utils = require("../../common/utils");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ExternalIncidentServiceConfigurationBase = exports.ExternalIncidentServiceConfigurationBase = {
  apiUrl: _zod.z.string(),
  isOAuth: _zod.z.boolean().default(false),
  userIdentifierValue: _zod.z.string().nullable().default(null),
  // required if isOAuth = true
  clientId: _zod.z.string().nullable().default(null),
  // required if isOAuth = true
  jwtKeyId: _zod.z.string().nullable().default(null) // required if isOAuth = true
};
const ExternalIncidentServiceConfiguration = exports.ExternalIncidentServiceConfiguration = {
  ...ExternalIncidentServiceConfigurationBase,
  usesTableApi: _zod.z.boolean().default(true)
};
const ExternalIncidentServiceConfigurationBaseSchema = exports.ExternalIncidentServiceConfigurationBaseSchema = _zod.z.object(ExternalIncidentServiceConfigurationBase).strict();
const ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfigurationSchema = _zod.z.object(ExternalIncidentServiceConfiguration).strict();
const ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceSecretConfiguration = {
  password: _zod.z.string().nullable().default(null),
  // required if isOAuth = false
  username: _zod.z.string().nullable().default(null),
  // required if isOAuth = false
  clientSecret: _zod.z.string().nullable().default(null),
  // required if isOAuth = true
  privateKey: _zod.z.string().nullable().default(null),
  // required if isOAuth = true
  privateKeyPassword: _zod.z.string().nullable().default(null)
};
const ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfigurationSchema = _zod.z.object(ExternalIncidentServiceSecretConfiguration).strict();
const CommentsSchema = exports.CommentsSchema = _zod.z.array(_zod.z.object({
  comment: _zod.z.string(),
  commentId: _zod.z.string()
}).strict()).nullable().default(null);
const validateOtherFieldsKeys = (key, ctx) => {
  (0, _utils.validateKeysAllowed)({
    key,
    ctx,
    disallowList: commonIncidentSchemaObjectProperties,
    fieldName: 'additional_fields'
  });
};
exports.validateOtherFieldsKeys = validateOtherFieldsKeys;
const CommonAttributes = exports.CommonAttributes = {
  short_description: _zod.z.string(),
  description: _zod.z.string().nullable().default(null),
  externalId: _zod.z.string().nullable().default(null),
  category: _zod.z.string().nullable().default(null),
  subcategory: _zod.z.string().nullable().default(null),
  correlation_id: _zod.z.string().nullable().default(_constants.DEFAULT_ALERTS_GROUPING_KEY),
  correlation_display: _zod.z.string().nullable().default(null),
  additional_fields: (0, _utils.Coerced)(_zod.z.record(_zod.z.string().superRefine((value, ctx) => {
    validateOtherFieldsKeys(value, ctx);
  }), _zod.z.any()).superRefine((val, ctx) => (0, _utils.validateRecordMaxKeys)({
    record: val,
    ctx,
    maxNumberOfFields: _constants.MAX_ADDITIONAL_FIELDS_LENGTH,
    fieldName: 'additional_fields'
  })).nullable().default(null))
};
const commonIncidentSchemaObjectProperties = exports.commonIncidentSchemaObjectProperties = Object.keys(CommonAttributes);
const ExecutorSubActionGetChoicesParamsSchema = exports.ExecutorSubActionGetChoicesParamsSchema = _zod.z.object({
  fields: _zod.z.array(_zod.z.string())
}).strict();
const ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = _zod.z.object({
  externalId: _zod.z.string()
}).strict();
const ExecutorSubActionCloseIncidentParamsSchema = exports.ExecutorSubActionCloseIncidentParamsSchema = _zod.z.object({
  incident: _zod.z.object({
    externalId: _zod.z.string().nullable().default(null),
    correlation_id: _zod.z.string().default(_constants.DEFAULT_ALERTS_GROUPING_KEY).nullable()
  }).strict()
}).strict();

// Reserved for future implementation
const ExecutorSubActionHandshakeParamsSchema = exports.ExecutorSubActionHandshakeParamsSchema = _zod.z.object({}).strict();
const ExecutorSubActionCommonFieldsParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = _zod.z.object({}).strict();