"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CloudDefendCustomAssetsExtension = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/fleet-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../common/hooks/use_kibana");
var _constants = require("../../common/navigation/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_defend/public/components/fleet_extensions/custom_assets_extension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SECURITY_APP_NAME = 'securitySolutionUI';
const CloudDefendCustomAssetsExtension = () => {
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const views = [{
    name: _constants.cloudDefendPages.dashboard.name,
    url: application.getUrlForApp(SECURITY_APP_NAME, {
      path: _constants.cloudDefendPages.dashboard.path
    }),
    description: _i18n.i18n.translate('xpack.cloudDefend.createPackagePolicy.customAssetsTab.dashboardViewLabel', {
      defaultMessage: 'View k8s dashboard'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_public.CustomAssetsAccordion, {
    views: views,
    initialIsOpen: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 10
    }
  });
};
// eslint-disable-next-line import/no-default-export
exports.default = exports.CloudDefendCustomAssetsExtension = CloudDefendCustomAssetsExtension;