"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlYamlView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _monaco = require("@kbn/monaco");
var _lodash = require("lodash");
var _constants = require("../../../common/constants");
var _styles = require("./styles");
var _use_config_model = require("./hooks/use_config_model");
var _utils = require("../../common/utils");
var _helpers = require("../../../common/utils/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_defend/public/components/control_yaml_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  editor
} = _monaco.monaco;
const TEXT_EDITOR_PADDING = 10;
const ControlYamlView = ({
  policy,
  onChange,
  show
}) => {
  var _input$vars, _input$vars$configura;
  const styles = (0, _styles.useStyles)();
  const [editorErrors, setEditorErrors] = (0, _react.useState)([]);
  const [additionalErrors, setAdditionalErrors] = (0, _react.useState)([]);
  const input = (0, _helpers.getInputFromPolicy)(policy, _constants.INPUT_CONTROL);
  const configuration = (input === null || input === void 0 ? void 0 : (_input$vars = input.vars) === null || _input$vars === void 0 ? void 0 : (_input$vars$configura = _input$vars.configuration) === null || _input$vars$configura === void 0 ? void 0 : _input$vars$configura.value) || '';
  const currentModel = (0, _use_config_model.useConfigModel)(configuration);
  (0, _react.useEffect)(() => {
    if (currentModel && currentModel.getValue() !== configuration) {
      currentModel.setValue(configuration);
    }
  }, [currentModel, configuration]);

  // not all validations can be done via json-schema
  const validateAdditional = (0, _react.useCallback)(value => {
    const errors = [];
    const {
      selectors,
      responses
    } = (0, _helpers.getSelectorsAndResponsesFromYaml)(value);
    errors.push(...(0, _utils.validateMaxSelectorsAndResponses)(selectors, responses));
    errors.push(...(0, _utils.validateBlockRestrictions)(selectors, responses));

    // validate selectors
    selectors.forEach(selector => {
      Object.keys(selector).map(prop => {
        var _SelectorConditionsMa;
        const condition = prop;
        if (((_SelectorConditionsMa = _types.SelectorConditionsMap[condition]) === null || _SelectorConditionsMa === void 0 ? void 0 : _SelectorConditionsMa.type) === 'stringArray') {
          const values = selector[condition];
          errors.push(...(0, _utils.validateStringValuesForCondition)(condition, values));
        }
      });
    });

    // validate responses
    responses.forEach(response => {
      // for now we force 'alert' action if 'block' action added.
      if (response.actions && response.actions.includes('block') && !response.actions.includes('alert')) {
        errors.push(i18n.errorAlertActionRequired);
      }
    });
    return (0, _lodash.uniq)(errors);
  }, []);
  (0, _react.useEffect)(() => {
    if (!show) return;

    // for on mount
    const otherErrors = validateAdditional(configuration);
    if (otherErrors.length !== additionalErrors.length) {
      setAdditionalErrors(otherErrors);
    }
    const listener = editor.onDidChangeMarkers(([resource]) => {
      const markers = editor.getModelMarkers({
        resource
      });
      const errs = markers.map(marker => {
        const error = {
          line: marker.startLineNumber,
          message: marker.message
        };
        return error;
      });

      // prevents infinite loop
      if (otherErrors.length !== additionalErrors.length || JSON.stringify(errs) !== JSON.stringify(editorErrors)) {
        onChange({
          isValid: otherErrors.length === 0 && errs.length === 0,
          updatedPolicy: policy
        });
        setEditorErrors(errs);
      }
    });
    return () => {
      listener.dispose();
    };
  }, [editorErrors, onChange, policy, additionalErrors.length, validateAdditional, configuration, show]);
  const onYamlChange = (0, _react.useCallback)(value => {
    if (show && input !== null && input !== void 0 && input.vars) {
      input.vars.configuration.value = value;
      const errs = validateAdditional(value);
      setAdditionalErrors(errs);
      onChange({
        isValid: errs.length === 0 && editorErrors.length === 0,
        updatedPolicy: policy
      });
    }
  }, [editorErrors.length, input === null || input === void 0 ? void 0 : input.vars, onChange, policy, show, validateAdditional]);

  // render loading state if currentModel is not ready, to prevent monaco from calling setLanguage on null object
  if (!currentModel) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      css: !show && styles.hide,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 11
      }
    }, i18n.controlYamlLoading)));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: !show && styles.hide,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, i18n.controlYamlHelp), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }), additionalErrors.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "cloudDefendAdditionalErrors",
    isInvalid: true,
    error: additionalErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.yamlEditor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    width: "100%",
    languageId: _codeEditor.YAML_LANG_ID,
    options: {
      wordWrap: 'off',
      model: currentModel,
      automaticLayout: true,
      padding: {
        top: TEXT_EDITOR_PADDING,
        bottom: TEXT_EDITOR_PADDING
      }
    },
    onChange: onYamlChange,
    value: configuration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  })));
};
exports.ControlYamlView = ControlYamlView;