"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FullscreenControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactShortcuts = require("react-shortcuts");
var _is_text_input = require("../../../lib/is_text_input");
var _use_canvas_api = require("../../hooks/use_canvas_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/fullscreen_control/fullscreen_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error no @types definition
class FullscreenControl extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    /*
      We need these instance functions because ReactShortcuts bind the handlers on it's mount, 
      but then does no rebinding if it's props change. Using these instance functions will 
      properly handle changes to incoming props since the instance functions are bound to the components
      "this" context
    */
    (0, _defineProperty2.default)(this, "_toggleFullscreen", () => {
      const {
        setFullscreen,
        isFullscreen
      } = this.props;
      setFullscreen(!isFullscreen);
    });
    (0, _defineProperty2.default)(this, "toggleAutoplay", () => {
      this.props.toggleAutoplay();
    });
    (0, _defineProperty2.default)(this, "nextPage", () => {
      this.props.nextPage();
    });
    (0, _defineProperty2.default)(this, "previousPage", () => {
      this.props.previousPage();
    });
    // handle keypress events for presentation events
    (0, _defineProperty2.default)(this, "_keyMap", {
      REFRESH: () => {
        (0, _use_canvas_api.forceReload)();
        this.props.fetchAllRenderables();
      },
      PREV: this.previousPage,
      NEXT: this.nextPage,
      FULLSCREEN: this._toggleFullscreen,
      FULLSCREEN_EXIT: this._toggleFullscreen,
      PAGE_CYCLE_TOGGLE: this.toggleAutoplay
    });
    (0, _defineProperty2.default)(this, "_keyHandler", (action, event) => {
      if (Object.keys(this._keyMap).indexOf(action) < 0) {
        return;
      }
      if (!(0, _is_text_input.isTextInput)(event.target) && typeof this._keyMap[action] === 'function') {
        event.preventDefault();
        this._keyMap[action]();
      }
    });
  }
  render() {
    const {
      children,
      isFullscreen
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }, isFullscreen && /*#__PURE__*/_react.default.createElement(_reactShortcuts.Shortcuts, {
      name: "PRESENTATION",
      handler: this._keyHandler,
      targetNodeSelector: "body",
      global: true,
      isolate: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    }), children({
      isFullscreen,
      toggleFullscreen: this._toggleFullscreen
    }));
  }
}
exports.FullscreenControl = FullscreenControl;
(0, _defineProperty2.default)(FullscreenControl, "propTypes", {
  setFullscreen: _propTypes.default.func.isRequired,
  isFullscreen: _propTypes.default.bool.isRequired,
  children: _propTypes.default.func.isRequired
});