"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPalette = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _readable_color = require("../../lib/readable_color");
var _color_dot = require("../color_dot");
var _item_grid = require("../item_grid");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/color_palette/color_palette.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ColorPalette = ({
  colors = [],
  colorsPerRow = 6,
  onChange,
  value = ''
}) => {
  if (colors.length === 0) {
    return null;
  }
  colors = colors.filter(color => {
    return _chromaJs.default.valid(color);
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasColorPalette",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_item_grid.ItemGrid, {
    items: colors,
    itemsPerRow: colorsPerRow,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, color => {
    const match = (0, _chromaJs.default)(color).hex() === (0, _chromaJs.default)(value).hex();
    const icon = match ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      className: "selected-color",
      color: (0, _readable_color.readableColor)(value),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 13
      }
    }) : null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      css: {
        fontSize: 0
      },
      key: color,
      onClick: () => !match && onChange(color),
      className: "canvasColorPalette__dot",
      "aria-label": (0, _chromaJs.default)(color).name() || color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_color_dot.ColorDot, {
      value: color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 15
      }
    }, icon));
  }));
};
exports.ColorPalette = ColorPalette;
ColorPalette.propTypes = {
  colors: _propTypes.default.array,
  colorsPerRow: _propTypes.default.number,
  onChange: _propTypes.default.func.isRequired,
  value: _propTypes.default.string
};