"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AUTOMATIC_IMPORT_FEATURE = exports.AUTOMATIC_IMPORT_API_PRIVILEGES = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _i18n = require("@kbn/i18n");
var _saved_objects = require("./services/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AUTOMATIC_IMPORT_API_PRIVILEGES = exports.AUTOMATIC_IMPORT_API_PRIVILEGES = {
  READ: 'read_automatic_import',
  MANAGE: 'manage_automatic_import'
};
const AUTOMATIC_IMPORT_FEATURE = exports.AUTOMATIC_IMPORT_FEATURE = {
  id: 'automatic_import',
  name: _i18n.i18n.translate('xpack.automatic_import.featureRegistry.automaticImportFeatureName', {
    defaultMessage: 'Automatic Import'
  }),
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.management,
  app: [],
  privileges: {
    all: {
      app: [],
      api: [AUTOMATIC_IMPORT_API_PRIVILEGES.READ, AUTOMATIC_IMPORT_API_PRIVILEGES.MANAGE],
      catalogue: [],
      savedObject: {
        all: [_saved_objects.INTEGRATION_SAVED_OBJECT_TYPE, _saved_objects.DATA_STREAM_SAVED_OBJECT_TYPE],
        read: []
      },
      ui: ['view', 'approve', 'delete', 'create', 'edit', 'stop']
    },
    read: {
      app: [],
      api: [AUTOMATIC_IMPORT_API_PRIVILEGES.READ],
      catalogue: [],
      ui: ['view'],
      savedObject: {
        all: [],
        read: [_saved_objects.INTEGRATION_SAVED_OBJECT_TYPE, _saved_objects.DATA_STREAM_SAVED_OBJECT_TYPE]
      }
    }
  }
};