"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTools = void 0;
var _get_document_by_id = require("./get_document_by_id");
var _get_index_mapping = require("./get_index_mapping");
var _list_indices = require("./list_indices");
var _index_explorer = require("./index_explorer");
var _generate_esql = require("./generate_esql");
var _execute_esql = require("./execute_esql");
var _search = require("./search");
var _create_visualization = require("./create_visualization");
var _get_workflow_execution_status = require("./get_workflow_execution_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerTools = ({
  coreSetup,
  setupDeps
}) => {
  const {
    onechat
  } = setupDeps;
  const tools = [(0, _search.searchTool)(), (0, _get_document_by_id.getDocumentByIdTool)(), (0, _execute_esql.executeEsqlTool)(), (0, _generate_esql.generateEsqlTool)(), (0, _get_index_mapping.getIndexMappingsTool)(), (0, _list_indices.listIndicesTool)(), (0, _index_explorer.indexExplorerTool)(), (0, _create_visualization.createVisualizationTool)()];
  if (setupDeps.workflowsManagement) {
    tools.push((0, _get_workflow_execution_status.getWorkflowExecutionStatusTool)({
      workflowsManagement: setupDeps.workflowsManagement
    }));
  }
  tools.forEach(tool => {
    onechat.tools.register(tool);
  });
};
exports.registerTools = registerTools;