"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBeforeRedirectFn = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBeforeRedirectFn = configurationUtilities => {
  return options => {
    const hostname = options.hostname;
    if (hostname == null) {
      throw new Error('redirect hostname not provided by axios');
    }
    if (typeof hostname !== 'string') {
      throw new Error('redirect hostname provided by axios was not a string');
    }
    configurationUtilities.ensureHostnameAllowed(hostname);
  };
};
exports.getBeforeRedirectFn = getBeforeRedirectFn;