"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthTypeRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _v = require("@kbn/zod/v4");
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AuthTypeRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "authTypes", new Map());
  }

  /**
   * Returns if the auth type registry has the given action type registered
   */
  has(id) {
    return this.authTypes.has(id);
  }

  /**
   * Registers an auth type
   */
  register(authType) {
    if (this.has(authType.id)) {
      throw new Error(_i18n.i18n.translate('xpack.actions.authTypeRegistry.register.duplicateAuthTypeErrorMessage', {
        defaultMessage: 'Auth type "{id}" is already registered.',
        values: {
          id: authType.id
        }
      }));
    }
    if (!(authType.schema instanceof _v.z.ZodObject)) {
      throw new Error(_i18n.i18n.translate('xpack.actions.authTypeRegistry.register.invalidAuthTypeSchema', {
        defaultMessage: 'Auth type "{id}" has an invalid schema.',
        values: {
          id: authType.id
        }
      }));
    }
    this.authTypes.set(authType.id, {
      ...authType
    });
  }

  /**
   * Returns an auth type, throws if not registered
   */
  get(id) {
    if (!this.has(id)) {
      throw _boom.default.badRequest(_i18n.i18n.translate('xpack.actions.authTypeRegistry.get.missingAuthTypeErrorMessage', {
        defaultMessage: 'Auth type "{id}" is not registered.',
        values: {
          id
        }
      }));
    }
    return this.authTypes.get(id);
  }
  getAllTypes() {
    return Array.from(this.authTypes).map(([authTypeId]) => authTypeId);
  }
}
exports.AuthTypeRegistry = AuthTypeRegistry;