"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTimeZoneDisplay = void 0;
exports.useEuiUTCOffsetDisplay = useEuiUTCOffsetDisplay;
var _react = _interopRequireDefault(require("react"));
var _timezone_display = require("./timezone_display.styles");
var _services = require("../../../../services");
var _flex = require("../../../flex");
var _icon = require("../../../icon");
var _text = require("../../../text");
var _react2 = require("@emotion/react");
var _excluded = ["timeZone", "customRender", "date"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Available elements to render passed to the
 * `customRender` render function.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/**
 * Display time zone information.
 */
var EuiTimeZoneDisplay = exports.EuiTimeZoneDisplay = function EuiTimeZoneDisplay(_ref) {
  var timeZone = _ref.timeZone,
    customRender = _ref.customRender,
    date = _ref.date,
    rest = _objectWithoutProperties(_ref, _excluded);
  var color = 'subdued';
  var styles = (0, _services.useEuiMemoizedStyles)(_timezone_display.euiTimeZoneDisplayStyles);
  var referenceDate = date ? date.toDate() : undefined;
  var _useEuiUTCOffsetDispl = useEuiUTCOffsetDisplay(timeZone !== null && timeZone !== void 0 ? timeZone : 'Browser', referenceDate),
    utc = _useEuiUTCOffsetDispl.utc,
    name = _useEuiUTCOffsetDispl.name,
    isInvalid = _useEuiUTCOffsetDispl.isInvalid;
  if (!timeZone || isInvalid) return null;
  var label = !name ? utc : "".concat(utc, " (").concat(name, ")");
  var nameDisplay = (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "globe",
    color: color
  }), (0, _react2.jsx)(_text.EuiText, {
    component: "span",
    color: color,
    size: "s"
  }, label));
  return (0, _react2.jsx)(_flex.EuiFlexGroup, _extends({
    css: styles.euiTimeZoneDisplay,
    alignItems: "center",
    gutterSize: "xs",
    "data-test-subj": "euiTimeZoneDisplay",
    "aria-label": label
  }, rest), typeof customRender === 'function' ? customRender({
    nameDisplay: nameDisplay
  }) : nameDisplay);
};

/**
 * Get the UTC offset display in hours e.g. "UTC+2" from time zone name.
 *
 * @param timeZoneName IANA time zone name
 * @param [date] Reference date to get offset with Intl.DateTimeFormat
 */
function useEuiUTCOffsetDisplay(timeZoneName, date) {
  try {
    var _formattedParts$find;
    if (timeZoneName === 'UTC') {
      return {
        utc: 'UTC',
        name: '',
        isInvalid: false
      };
    }
    var ianaName = timeZoneName === 'Browser' ? new Intl.DateTimeFormat().resolvedOptions().timeZone : timeZoneName;
    var formatter = new Intl.DateTimeFormat(undefined, {
      timeZone: ianaName,
      timeZoneName: 'shortOffset'
    });
    var formattedParts = formatter.formatToParts(date !== null && date !== void 0 ? date : new Date());
    var timeZoneNamePart = ((_formattedParts$find = formattedParts.find(function (part) {
      return part.type === 'timeZoneName';
    })) === null || _formattedParts$find === void 0 ? void 0 : _formattedParts$find.value) || '';
    return {
      utc: timeZoneNamePart.replace('GMT', 'UTC'),
      name: ianaName,
      isInvalid: false
    };
  } catch (err) {
    return {
      utc: '',
      name: timeZoneName,
      isInvalid: true
    };
  }
}