"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _contentManagementContentInsightsServer = require("@kbn/content-management-content-insights-server");
var _common = require("@kbn/saved-objects-tagging-plugin/common");
var _dashboard_telemetry_collection_task = require("./usage/dashboard_telemetry_collection_task");
var _ui_settings = require("./ui_settings");
var _capabilities_provider = require("./capabilities_provider");
var _constants = require("../common/constants");
var _dashboard_saved_object = require("./dashboard_saved_object");
var _register_collector = require("./usage/register_collector");
var _dashboard_container_embeddable_factory = require("./dashboard_container/dashboard_container_embeddable_factory");
var _api = require("./api");
var _locator = require("../common/locator/locator");
var _kibana_services = require("./kibana_services");
var _scan_dashboards = require("./scan_dashboards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DashboardPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, plugins) {
    this.logger.debug('dashboard: Setup');
    core.savedObjects.registerType((0, _dashboard_saved_object.createDashboardSavedObjectType)({
      migrationDeps: {
        embeddable: plugins.embeddable
      }
    }));
    plugins.contentManagement.favorites.registerFavoriteType('dashboard');
    if (plugins.taskManager) {
      (0, _dashboard_telemetry_collection_task.initializeDashboardTelemetryTask)(this.logger, core, plugins.taskManager, plugins.embeddable);
    }
    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);
    if (plugins.usageCollection && plugins.taskManager) {
      (0, _register_collector.registerDashboardUsageCollector)(plugins.usageCollection, core.getStartServices().then(([_, {
        taskManager
      }]) => taskManager));
    }
    if (plugins.usageCollection) {
      // Registers routes for tracking and fetching dashboard views
      (0, _contentManagementContentInsightsServer.registerContentInsights)({
        usageCollection: plugins.usageCollection,
        http: core.http,
        getStartServices: () => core.getStartServices().then(([_, start]) => ({
          usageCollection: start.usageCollection
        }))
      }, {
        domainId: 'dashboard',
        // makes sure that only users with read/all access to dashboard app can access the routes
        routePrivileges: ['dashboardUsageStats']
      });
    }
    plugins.embeddable.registerEmbeddableFactory((0, _dashboard_container_embeddable_factory.dashboardPersistableStateServiceFactory)(plugins.embeddable));
    core.uiSettings.register((0, _ui_settings.getUISettings)());
    (0, _api.registerRoutes)(core.http);
    return {};
  }
  start(core, plugins) {
    this.logger.debug('dashboard: Started');
    (0, _kibana_services.setKibanaServices)(plugins, this.logger);
    if (plugins.share) {
      plugins.share.url.locators.create(new _locator.DashboardAppLocatorDefinition({
        useHashedUrl: false,
        getDashboardFilterFields: async dashboardId => {
          throw new Error('Locator .getLocation() is not supported on the server with the `preserveSavedFilters` parameter.');
        }
      }));
    }
    if (plugins.taskManager) {
      (0, _dashboard_telemetry_collection_task.scheduleDashboardTelemetry)(this.logger, plugins.taskManager).then(async () => {
        await plugins.taskManager.runSoon(_dashboard_telemetry_collection_task.TASK_ID);
      }).catch(e => {
        this.logger.debug(`Error scheduling task, received ${e.message}`);
      });
    }
    return {
      getDashboard: async (ctx, id) => {
        const {
          core: coreCtx
        } = await ctx.resolve(['core']);
        const soResponse = await coreCtx.savedObjects.client.resolve(_constants.DASHBOARD_SAVED_OBJECT_TYPE, id);
        return {
          id: soResponse.saved_object.id,
          description: soResponse.saved_object.attributes.description,
          tags: soResponse.saved_object.references.filter(({
            type
          }) => type === _common.tagSavedObjectTypeName).map(ref => ref.id),
          title: soResponse.saved_object.attributes.title
        };
      },
      scanDashboards: _scan_dashboards.scanDashboards,
      client: {
        create: _api.create,
        read: _api.read,
        update: _api.update,
        delete: _api.deleteDashboard
      }
    };
  }
  stop() {}
}
exports.DashboardPlugin = DashboardPlugin;