"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UI_SETTINGS = exports.DEFAULT_PANEL_WIDTH = exports.DEFAULT_PANEL_HEIGHT = exports.DEFAULT_DASHBOARD_OPTIONS = exports.DASHBOARD_SAVED_OBJECT_TYPE = exports.DASHBOARD_API_VERSION = void 0;
var _page_bundle_constants = require("./page_bundle_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DASHBOARD_API_VERSION = exports.DASHBOARD_API_VERSION = '1';
const DASHBOARD_SAVED_OBJECT_TYPE = exports.DASHBOARD_SAVED_OBJECT_TYPE = 'dashboard';
const DEFAULT_PANEL_WIDTH = exports.DEFAULT_PANEL_WIDTH = _page_bundle_constants.DASHBOARD_GRID_COLUMN_COUNT / 2;
const DEFAULT_PANEL_HEIGHT = exports.DEFAULT_PANEL_HEIGHT = 15;
const DEFAULT_DASHBOARD_OPTIONS = exports.DEFAULT_DASHBOARD_OPTIONS = {
  hidePanelTitles: false,
  useMargins: true,
  syncColors: false,
  syncCursor: true,
  syncTooltips: false
};
const UI_SETTINGS = exports.UI_SETTINGS = {
  ENABLE_LABS_UI: 'labs:dashboard:enable_ui'
};