"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Logo = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _menu_item = require("../menu_item");
var _constants = require("../../constants");
var _use_tooltip = require("../../hooks/use_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/side_nav/logo.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const Logo = ({
  isCollapsed,
  isCurrent,
  isHighlighted,
  label,
  ...props
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    tooltipRef,
    handleMouseOut
  } = (0, _use_tooltip.useTooltip)();

  /**
   * **Icon size**
   *
   * In Figma, the logo icon is 20x20.
   * `EuiIcon` supports `l` which is 24x24 and `m` which is 16x16.
   *
   * **Padding**
   *
   * 7px aligns better with other elements in the layout.
   * We cannot use `euiTheme.size.s` because it's 8px.
   */
  const wrapperStyles = (0, _react2.css)`
    border-bottom: ${euiTheme.border.width.thin} solid ${euiTheme.colors.borderBaseSubdued};
    padding-top: ${isCollapsed ? euiTheme.size.s : euiTheme.size.m};
    padding-bottom: ${isCollapsed ? '7px' : euiTheme.size.m};

    .euiText {
      font-weight: ${euiTheme.font.weight.bold};
    }

    svg {
      height: 20px;
      width: 20px;
    }
  `;
  const logoWrapperTestSubj = `${_constants.NAVIGATION_SELECTOR_PREFIX}-logoWrapper`;
  const logoTestSubj = `${_constants.NAVIGATION_SELECTOR_PREFIX}-logo`;
  const menuItem = /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": logoWrapperTestSubj,
    css: wrapperStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_menu_item.MenuItem, (0, _extends2.default)({
    "aria-label": _i18n.i18n.translate('core.ui.chrome.sideNavigation.logoAriaLabel', {
      defaultMessage: '{label} homepage',
      values: {
        label
      }
    }),
    "data-test-subj": logoTestSubj,
    isHighlighted: isHighlighted,
    isCurrent: isCurrent,
    isLabelVisible: !isCollapsed,
    isTruncated: false
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), label));
  if (isCollapsed) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      ref: tooltipRef,
      content: label,
      disableScreenReaderOutput: true,
      onMouseOut: handleMouseOut,
      position: "right",
      repositionOnScroll: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 7
      }
    }, menuItem);
  }
  return menuItem;
};
exports.Logo = Logo;