"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAIN_PANEL_LABELS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MAIN_PANEL_LABELS = exports.MAIN_PANEL_LABELS = {
  get consolePageHeading() {
    return _i18n.i18n.translate('console.pageHeading', {
      defaultMessage: 'Console'
    });
  },
  get importButton() {
    return _i18n.i18n.translate('console.importButtonLabel', {
      defaultMessage: 'Import requests'
    });
  },
  get importButtonTooltip() {
    return _i18n.i18n.translate('console.importButtonTooltipLabel', {
      defaultMessage: 'Import requests from a file into the editor'
    });
  },
  get exportButton() {
    return _i18n.i18n.translate('console.exportButton', {
      defaultMessage: 'Export requests'
    });
  },
  get exportButtonTooltip() {
    return _i18n.i18n.translate('console.exportButtonTooltipLabel', {
      defaultMessage: 'Export all console requests to a TXT file'
    });
  },
  get helpButton() {
    return _i18n.i18n.translate('console.helpButtonTooltipContent', {
      defaultMessage: 'Help'
    });
  },
  get shortcutsButton() {
    return _i18n.i18n.translate('console.shortcutsButtonAriaLabel', {
      defaultMessage: 'Keyboard shortcuts'
    });
  },
  get variablesButton() {
    return _i18n.i18n.translate('console.variablesButton', {
      defaultMessage: 'Variables'
    });
  },
  get openFullscrenButton() {
    return _i18n.i18n.translate('console.openFullscreenButton', {
      defaultMessage: 'Open this console as a full page experience'
    });
  },
  get closeFullscrenButton() {
    return _i18n.i18n.translate('console.closeFullscreenButton', {
      defaultMessage: 'Close full page experience'
    });
  }
};