"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGraph = void 0;
var _fetch_graph = require("./fetch_graph");
var _parse_records = require("./parse_records");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGraph = async ({
  services: {
    esClient,
    logger
  },
  query: {
    originEventIds,
    spaceId = 'default',
    indexPatterns,
    start,
    end,
    esQuery
  },
  showUnknownTarget,
  nodesLimit
}) => {
  var _indexPatterns;
  indexPatterns = (_indexPatterns = indexPatterns) !== null && _indexPatterns !== void 0 ? _indexPatterns : [`.alerts-security.alerts-${spaceId}`, 'logs-*'];
  logger.trace(`Fetching graph for [originEventIds: ${originEventIds.join(', ')}] in [spaceId: ${spaceId}] [indexPatterns: ${indexPatterns.join(',')}]`);
  const results = await (0, _fetch_graph.fetchGraph)({
    esClient,
    showUnknownTarget,
    logger,
    start,
    end,
    originEventIds,
    indexPatterns,
    spaceId,
    esQuery
  });

  // Convert results into set of nodes and edges
  return (0, _parse_records.parseRecords)(logger, results.records, nodesLimit);
};
exports.getGraph = getGraph;