"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityDetectionRuleCounter = void 0;
var _react = _interopRequireDefault(require("react"));
var _detection_rule_counter = require("../../../components/detection_rule_counter");
var _create_detection_rule_from_vulnerability = require("../utils/create_detection_rule_from_vulnerability");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/vulnerabilities/vulnerabilities_finding_flyout/vulnerability_detection_rule_counter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const VulnerabilityDetectionRuleCounter = ({
  vulnerabilityRecord
}) => {
  const tags = (0, _create_detection_rule_from_vulnerability.getVulnerabilityTags)(vulnerabilityRecord);
  const createVulnerabilityRuleFn = async http => await (0, _create_detection_rule_from_vulnerability.createDetectionRuleFromVulnerabilityFinding)(http, vulnerabilityRecord);
  return /*#__PURE__*/_react.default.createElement(_detection_rule_counter.DetectionRuleCounter, {
    tags: tags,
    createRuleFn: createVulnerabilityRuleFn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 10
    }
  });
};
exports.VulnerabilityDetectionRuleCounter = VulnerabilityDetectionRuleCounter;