"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUserMenuLinks = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _appearance_selector = require("./appearance_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cloud_integrations/cloud_links/public/maybe_add_cloud_links/user_menu_links.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createUserMenuLinks = async ({
  core,
  cloud,
  security,
  isServerless
}) => {
  const {
    profileUrl,
    organizationUrl
  } = cloud;
  const userMenuLinks = [];
  if (profileUrl) {
    userMenuLinks.push({
      label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.profileLinkText', {
        defaultMessage: 'Profile'
      }),
      iconType: 'user',
      href: profileUrl,
      order: 100,
      setAsProfile: true
    });
  }
  const {
    billingUrl
  } = await cloud.getPrivilegedUrls();
  if (billingUrl) {
    userMenuLinks.push({
      label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.billingLinkText', {
        defaultMessage: 'Billing'
      }),
      iconType: 'visGauge',
      href: billingUrl,
      order: 200
    });
  }
  if (organizationUrl) {
    userMenuLinks.push({
      label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.organizationLinkText', {
        defaultMessage: 'Organization'
      }),
      iconType: 'gear',
      href: organizationUrl,
      order: 300
    });
  }
  userMenuLinks.push({
    content: ({
      closePopover
    }) => /*#__PURE__*/_react.default.createElement(_appearance_selector.AppearanceSelector, {
      core: core,
      security: security,
      closePopover: closePopover,
      isServerless: isServerless,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 7
      }
    }),
    order: 400,
    label: '',
    iconType: '',
    href: ''
  });
  return userMenuLinks;
};
exports.createUserMenuLinks = createUserMenuLinks;