"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Warnings = Warnings;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/charts/public/static/components/warnings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Warnings({
  warnings,
  compressed = false,
  'data-test-subj': dataTestSubj = 'chart-inline-warning-button'
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [open, setOpen] = (0, _react2.useState)(false);
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const onWarningButtonClick = (0, _react2.useCallback)(() => {
    setOpen(!open);
  }, [open]);
  if (warnings.length === 0) return null;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    isOpen: open,
    panelPaddingSize: "none",
    closePopover: () => setOpen(false),
    button: compressed ? /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      color: "warning",
      css: (0, _react.css)`
                block-size: ${euiTheme.size.l};
                border-radius: 0 ${euiTheme.border.radius.medium} 0 ${euiTheme.border.radius.small};
                font-size: ${xsFontSize};
                padding: 0 ${euiTheme.size.xs};
                & > * {
                  gap: ${euiTheme.size.xs};
                }
              `,
      iconSize: "s",
      iconType: "warning",
      minWidth: 0,
      onClick: onWarningButtonClick,
      size: "s",
      "data-test-subj": dataTestSubj,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 13
      }
    }, warnings.length) : /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      color: "warning",
      iconType: "warning",
      onClick: onWarningButtonClick,
      size: "xs",
      "data-test-subj": dataTestSubj,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('charts.warning.warningLabel', {
      defaultMessage: '{numberWarnings, number} {numberWarnings, plural, one {warning} other {warnings}}',
      values: {
        numberWarnings: warnings.length
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: {
      maxWidth: 512
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, warnings.map((w, i) => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, {
    key: i,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: {
      padding: euiTheme.size.s
    },
    "data-test-subj": "chart-inline-warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 17
    }
  }, w)), i < warnings.length - 1 && /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 43
    }
  }))))));
}