"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _domain = require("../../../../common/types/domain");
var _kibana = require("../../../common/lib/kibana");
var _use_get_issue_types = require("./use_get_issue_types");
var _card = require("../card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/jira/case_fields_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JiraFieldsPreviewComponent = ({
  fields,
  connector
}) => {
  var _fields$otherFields;
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    issueType = null,
    priority = null,
    parent = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    isLoading,
    isFetching,
    data: issueTypesData
  } = (0, _use_get_issue_types.useGetIssueTypes)({
    connector,
    http
  });
  const issueTypes = issueTypesData === null || issueTypesData === void 0 ? void 0 : issueTypesData.data;
  const otherFields = (_fields$otherFields = fields === null || fields === void 0 ? void 0 : fields.otherFields) !== null && _fields$otherFields !== void 0 ? _fields$otherFields : '';
  const listItems = (0, _react.useMemo)(() => {
    var _find$name, _find;
    return [...(issueType != null && issueType.length > 0 ? [{
      title: i18n.ISSUE_TYPE,
      description: (_find$name = (_find = (issueTypes !== null && issueTypes !== void 0 ? issueTypes : []).find(issue => issue.id === issueType)) === null || _find === void 0 ? void 0 : _find.name) !== null && _find$name !== void 0 ? _find$name : ''
    }] : []), ...(parent != null && parent.length > 0 ? [{
      title: i18n.PARENT_ISSUE,
      description: parent
    }] : []), ...(priority != null && priority.length > 0 ? [{
      title: i18n.PRIORITY,
      description: priority
    }] : []), ...(otherFields != null && otherFields.length > 0 ? [{
      title: i18n.OTHER_FIELDS,
      description: otherFields,
      displayAsCodeBlock: true
    }] : [])];
  }, [issueType, issueTypes, parent, priority, otherFields]);
  return /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _domain.ConnectorTypes.jira,
    isLoading: isLoading || isFetching,
    listItems: listItems,
    title: connector.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  });
};
exports.default = JiraFieldsPreviewComponent;
JiraFieldsPreviewComponent.displayName = 'JiraFieldsPreview';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;