"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CasesProvider = exports.CasesContext = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _reactQuery = require("@kbn/react-query");
var _cases_global_components = require("./cases_global_components");
var _constants = require("../../../common/constants");
var _files = require("../../../common/files");
var _navigation = require("../../common/navigation");
var _cases_context_reducer = require("./state/cases_context_reducer");
var _cases_state_context = require("./state/cases_state_context");
var _files2 = require("../../files");
var _query_client = require("./query_client");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/cases_context/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CasesContext = exports.CasesContext = /*#__PURE__*/_react.default.createContext(undefined);
const CasesProvider = ({
  children,
  value: {
    externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry,
    owner,
    permissions,
    basePath = _navigation.DEFAULT_BASE_PATH,
    features = {},
    releasePhase = 'ga',
    getFilesClient
  },
  queryClient = _query_client.casesQueryClient
}) => {
  const [state, dispatch] = (0, _react.useReducer)(_cases_context_reducer.casesContextReducer, (0, _cases_context_reducer.getInitialCasesContextState)());
  const value = (0, _react.useMemo)(() => ({
    externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry,
    owner,
    permissions: {
      all: permissions.all,
      connectors: permissions.connectors,
      create: permissions.create,
      delete: permissions.delete,
      push: permissions.push,
      read: permissions.read,
      settings: permissions.settings,
      update: permissions.update,
      reopenCase: permissions.reopenCase,
      createComment: permissions.createComment,
      assign: permissions.assign
    },
    basePath,
    /**
     * The empty object at the beginning avoids the mutation
     * of the DEFAULT_FEATURES object
     */
    features: (0, _lodash.merge)({}, _constants.DEFAULT_FEATURES, features),
    releasePhase,
    dispatch
  }),
  /**
   * We want to trigger a rerender only when the permissions will change.
   * The registries, the owner, and the rest of the values should
   * not change during the lifecycle of the cases application.
   */
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [permissions.all, permissions.connectors, permissions.create, permissions.delete, permissions.push, permissions.read, permissions.settings, permissions.update, permissions.reopenCase, permissions.createComment, permissions.assign]);
  const applyFilesContext = (0, _react.useCallback)(contextChildren => {
    if (owner.length === 0) {
      return contextChildren;
    }
    if ((0, _files2.isRegisteredOwner)(owner[0])) {
      return /*#__PURE__*/_react.default.createElement(_sharedUxFileContext.FilesContext, {
        client: getFilesClient((0, _files.constructFileKindIdByOwner)(owner[0])),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 11
        }
      }, contextChildren);
    } else {
      throw new Error('Invalid owner provided to cases context. See https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/cases/README.md#casescontext-setup');
    }
  }, [getFilesClient, owner]);
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_cases_state_context.CasesStateContext.Provider, {
    value: state,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(CasesContext.Provider, {
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }, applyFilesContext(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_cases_global_components.CasesGlobalComponents, {
    state: state,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }), children)))));
};
exports.CasesProvider = CasesProvider;
CasesProvider.displayName = 'CasesProvider';

// eslint-disable-next-line import/no-default-export
var _default = exports.default = CasesProvider;