"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RevealImageComponent = RevealImageComponent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _lib = require("../../../public/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/renderers/reveal_image/reveal_image_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const revealImageParentStyle = (0, _react2.css)`
  height: 100%;
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
  pointer-events: none;
`;
const revealImageAlignerStyle = {
  backgroundSize: 'contain',
  backgroundRepeat: 'no-repeat'
};
const revealImageStyle = {
  userSelect: 'none'
};
function RevealImageComponent({
  onLoaded,
  parentNode,
  percent,
  origin,
  image,
  emptyImage
}) {
  const [loaded, setLoaded] = (0, _react.useState)(false);
  const [dimensions, setDimensions] = (0, _react.useState)({
    width: 1,
    height: 1
  });
  const imgRef = (0, _react.useRef)(null);
  const parentNodeDimensions = (0, _eui.useResizeObserver)(parentNode);

  // modify the top-level container class
  parentNode.className = 'revealImage';
  parentNode.setAttribute('style', revealImageParentStyle.styles);

  // set up the overlay image
  const updateImageView = (0, _react.useCallback)(() => {
    if (imgRef.current) {
      setDimensions({
        height: imgRef.current.naturalHeight,
        width: imgRef.current.naturalWidth
      });
      setLoaded(true);
      onLoaded();
    }
  }, [imgRef, onLoaded]);
  (0, _react.useEffect)(() => {
    updateImageView();
  }, [parentNodeDimensions, updateImageView]);
  function getClipPath(percentParam, originParam = 'bottom') {
    const directions = {
      bottom: 0,
      left: 1,
      top: 2,
      right: 3
    };
    const values = [0, 0, 0, 0];
    values[directions[originParam]] = `${100 - percentParam * 100}%`;
    return `inset(${values.join(' ')})`;
  }
  function getImageSizeStyle() {
    const imgStyles = {};
    const imgDimensions = {
      height: dimensions.height,
      width: dimensions.width,
      ratio: dimensions.height / dimensions.width
    };
    const domNodeDimensions = {
      width: parentNode.clientWidth,
      height: parentNode.clientHeight,
      ratio: parentNode.clientHeight / parentNode.clientWidth
    };
    if (imgDimensions.ratio > domNodeDimensions.ratio) {
      imgStyles.height = domNodeDimensions.height;
      imgStyles.width = 'initial';
    } else {
      imgStyles.width = domNodeDimensions.width;
      imgStyles.height = 'initial';
    }
    return imgStyles;
  }
  const additionalAlignerStyles = {};
  if ((0, _lib.isValidUrl)(emptyImage !== null && emptyImage !== void 0 ? emptyImage : '')) {
    // only use empty image if one is provided
    additionalAlignerStyles.backgroundImage = `url(${emptyImage})`;
  }
  let additionalImgStyles = {};
  if (imgRef.current && loaded) additionalImgStyles = getImageSizeStyle();
  additionalImgStyles.clipPath = getClipPath(percent, origin);
  if (imgRef.current && loaded) {
    imgRef.current.style.setProperty('-webkit-clip-path', getClipPath(percent, origin));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "revealImageAligner",
    css: {
      ...revealImageAlignerStyle,
      ...additionalAlignerStyles
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("img", {
    ref: imgRef,
    onLoad: updateImageView,
    css: (0, _react2.css)({
      ...revealImageStyle,
      ...additionalImgStyles
    }),
    src: image,
    alt: "",
    role: "presentation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }));
}