"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsChart = MetricsChart;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _formatters = require("../../../../../common/utils/formatters");
var _timeseries_chart_with_context = require("../timeseries_chart_with_context");
var _helper = require("../transaction_charts/helper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/metrics_chart/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getYTickFormatter(chart) {
  const max = (0, _helper.getMaxY)(chart.series);
  switch (chart.yUnit) {
    case 'bytes':
      {
        return (0, _formatters.getFixedByteFormatter)(max);
      }
    case 'percent':
      {
        return y => (0, _formatters.asPercent)(y || 0, 1);
      }
    case 'time':
      {
        const durationFormatter = (0, _formatters.getDurationFormatter)(max);
        return (0, _helper.getResponseTimeTickFormatter)(durationFormatter);
      }
    case 'integer':
      {
        return _formatters.asInteger;
      }
    default:
      {
        return _formatters.asDecimal;
      }
  }
}
function MetricsChart({
  chart,
  fetchStatus
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, chart.title))), chart.description && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: chart.description,
    position: "top",
    type: "question",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    fetchStatus: fetchStatus,
    id: chart.key,
    timeseries: chart.series,
    yLabelFormat: getYTickFormatter(chart),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
}