"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WriteOperations = exports.ReadOperations = exports.AlertingAuthorizationEntity = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AlertingAuthorizationEntity = exports.AlertingAuthorizationEntity = /*#__PURE__*/function (AlertingAuthorizationEntity) {
  AlertingAuthorizationEntity["Rule"] = "rule";
  AlertingAuthorizationEntity["Alert"] = "alert";
  return AlertingAuthorizationEntity;
}({});
let ReadOperations = exports.ReadOperations = /*#__PURE__*/function (ReadOperations) {
  ReadOperations["Get"] = "get";
  ReadOperations["BulkGet"] = "bulkGet";
  ReadOperations["GetRuleState"] = "getRuleState";
  ReadOperations["GetAlertSummary"] = "getAlertSummary";
  ReadOperations["GetExecutionLog"] = "getExecutionLog";
  ReadOperations["GetActionErrorLog"] = "getActionErrorLog";
  ReadOperations["Find"] = "find";
  ReadOperations["GetAuthorizedAlertsIndices"] = "getAuthorizedAlertsIndices";
  ReadOperations["GetRuleExecutionKPI"] = "getRuleExecutionKPI";
  ReadOperations["GetBackfill"] = "getBackfill";
  ReadOperations["FindBackfill"] = "findBackfill";
  ReadOperations["FindGaps"] = "findGaps";
  ReadOperations["GetGapAutoFillScheduler"] = "getGapAutoFillScheduler";
  ReadOperations["GetGapAutoFillSchedulerLogs"] = "getGapAutoFillSchedulerLogs";
  ReadOperations["BulkEditParams"] = "bulkEditParams";
  return ReadOperations;
}({}); // special operation for bulk editing rule params
let WriteOperations = exports.WriteOperations = /*#__PURE__*/function (WriteOperations) {
  WriteOperations["Create"] = "create";
  WriteOperations["Delete"] = "delete";
  WriteOperations["Update"] = "update";
  WriteOperations["UpdateApiKey"] = "updateApiKey";
  WriteOperations["Enable"] = "enable";
  WriteOperations["Disable"] = "disable";
  WriteOperations["MuteAll"] = "muteAll";
  WriteOperations["UnmuteAll"] = "unmuteAll";
  WriteOperations["MuteAlert"] = "muteAlert";
  WriteOperations["UnmuteAlert"] = "unmuteAlert";
  WriteOperations["Snooze"] = "snooze";
  WriteOperations["BulkEdit"] = "bulkEdit";
  WriteOperations["BulkDelete"] = "bulkDelete";
  WriteOperations["BulkEnable"] = "bulkEnable";
  WriteOperations["BulkDisable"] = "bulkDisable";
  WriteOperations["Unsnooze"] = "unsnooze";
  WriteOperations["RunSoon"] = "runSoon";
  WriteOperations["ScheduleBackfill"] = "scheduleBackfill";
  WriteOperations["DeleteBackfill"] = "deleteBackfill";
  WriteOperations["FillGaps"] = "fillGaps";
  WriteOperations["CreateGapAutoFillScheduler"] = "createGapAutoFillScheduler";
  WriteOperations["UpdateGapAutoFillScheduler"] = "updateGapAutoFillScheduler";
  WriteOperations["DeleteGapAutoFillScheduler"] = "deleteGapAutoFillScheduler";
  return WriteOperations;
}({});