"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiFlyoutSessionContext = exports.EuiFlyoutSessionProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _index = require("../index");
var _flyout_reducer = require("./flyout_reducer");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiFlyoutSessionContext = /*#__PURE__*/(0, _react.createContext)(null);

/**
 * Accesses the state data and dispatch function from the context of EuiFlyoutSessionProvider
 * Use this if you need to debug the state or need direct access to the dispatch function, otherwise use useEuiFlyoutSession hook.
 */
var useEuiFlyoutSessionContext = exports.useEuiFlyoutSessionContext = function useEuiFlyoutSessionContext() {
  var context = (0, _react.useContext)(EuiFlyoutSessionContext);
  if (!context) {
    throw new Error('useEuiFlyoutSessionContext must be used within a EuiFlyoutSessionProvider');
  }
  return context;
};

/**
 * FlyoutProvider is a component that provides a context for Flyout components.
 * It is used to manage the state of the Flyout and its child.
 * It also renders the Flyout and FlyoutChild components.
 *
 * @param children - The children of the FlyoutProvider component.
 * @param renderMainFlyoutContent - A function that renders the content of the main Flyout.
 * @param renderChildFlyoutContent - A function that renders the content of the child Flyout.
 * @returns The FlyoutProvider component.
 */
var EuiFlyoutSessionProvider = exports.EuiFlyoutSessionProvider = function EuiFlyoutSessionProvider(_ref) {
  var children = _ref.children,
    renderMainFlyoutContent = _ref.renderMainFlyoutContent,
    renderChildFlyoutContent = _ref.renderChildFlyoutContent,
    onUnmount = _ref.onUnmount;
  var _useReducer = (0, _react.useReducer)(_flyout_reducer.flyoutReducer, _flyout_reducer.initialFlyoutState),
    _useReducer2 = _slicedToArray(_useReducer, 2),
    state = _useReducer2[0],
    dispatch = _useReducer2[1];
  var activeFlyoutGroup = state.activeFlyoutGroup;
  var handleClose = function handleClose() {
    dispatch({
      type: 'CLOSE_SESSION'
    });
  };
  var handleCloseChild = function handleCloseChild() {
    dispatch({
      type: 'CLOSE_CHILD_FLYOUT'
    });
  };
  var mainFlyoutContentNode = null;
  var childFlyoutContentNode = null;
  if (activeFlyoutGroup) {
    var renderContext = {
      activeFlyoutGroup: activeFlyoutGroup,
      meta: activeFlyoutGroup.meta
    };
    mainFlyoutContentNode = renderMainFlyoutContent(renderContext);
    if (activeFlyoutGroup.isChildOpen && renderChildFlyoutContent) {
      childFlyoutContentNode = renderChildFlyoutContent(renderContext);
    } else if (activeFlyoutGroup.isChildOpen && !renderChildFlyoutContent) {
      console.warn('EuiFlyoutSessionProvider: A child flyout is open, but renderChildFlyoutContent was not provided.');
    }
  }
  var config = activeFlyoutGroup === null || activeFlyoutGroup === void 0 ? void 0 : activeFlyoutGroup.config;
  var flyoutPropsMain = (config === null || config === void 0 ? void 0 : config.mainFlyoutProps) || {};
  var flyoutPropsChild = (config === null || config === void 0 ? void 0 : config.childFlyoutProps) || {};
  return (0, _react2.jsx)(EuiFlyoutSessionContext.Provider, {
    value: {
      state: state,
      dispatch: dispatch,
      onUnmount: onUnmount
    }
  }, children, (activeFlyoutGroup === null || activeFlyoutGroup === void 0 ? void 0 : activeFlyoutGroup.isMainOpen) && (0, _react2.jsx)(_index.EuiFlyout, _extends({
    onClose: handleClose,
    size: config === null || config === void 0 ? void 0 : config.mainSize,
    ownFocus: !activeFlyoutGroup.isChildOpen
  }, flyoutPropsMain), mainFlyoutContentNode, activeFlyoutGroup.isChildOpen && childFlyoutContentNode && (0, _react2.jsx)(_index.EuiFlyoutChild, _extends({
    onClose: handleCloseChild,
    size: config === null || config === void 0 ? void 0 : config.childSize
  }, flyoutPropsChild), childFlyoutContentNode)));
};