"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountChart = void 0;
exports.LoadingSpinner = LoadingSpinner;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _visualizationUtils = require("@kbn/visualization-utils");
var _kibana_context = require("../../../../kibana_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/document_count_content/document_count_chart/document_count_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SPEC_ID = 'document_count';
function LoadingSpinner() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignItems: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "loadingSpinner",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }));
}
const DocumentCountChart = ({
  width,
  chartPoints,
  timeRangeEarliest,
  timeRangeLatest,
  interval,
  loading
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      data,
      uiSettings,
      fieldFormats,
      charts
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const chartBaseTheme = charts.theme.useChartsBaseTheme();
  const xAxisFormatter = fieldFormats.deserialize({
    id: 'date'
  });
  const seriesName = _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.field.documentCountChart.seriesLabel', {
    defaultMessage: 'document count'
  });
  const adjustedChartPoints = (0, _react.useMemo)(() => {
    // Display empty chart when no data in range
    if (chartPoints.length < 1) return [{
      time: timeRangeEarliest,
      value: 0
    }];

    // If chart has only one bucket
    // it won't show up correctly unless we add an extra data point
    if (chartPoints.length === 1) {
      return [...chartPoints, {
        time: interval ? Number(chartPoints[0].time) + interval : timeRangeEarliest,
        value: 0
      }];
    }
    return chartPoints;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [chartPoints, timeRangeEarliest, timeRangeLatest, interval]);
  const timefilterUpdateHandler = (0, _react.useCallback)(ranges => {
    data.query.timefilter.timefilter.setTime({
      from: (0, _moment.default)(ranges.from).toISOString(),
      to: (0, _moment.default)(ranges.to).toISOString(),
      mode: 'absolute'
    });
  }, [data]);
  const onBrushEnd = ({
    x
  }) => {
    if (!x) {
      return;
    }
    const [from, to] = x;
    timefilterUpdateHandler({
      from,
      to
    });
  };
  const onElementClick = ([elementData]) => {
    const startRange = elementData[0].x;
    const range = {
      from: startRange,
      to: startRange + interval
    };
    timefilterUpdateHandler(range);
  };
  const timeZone = (0, _visualizationUtils.getTimeZone)(uiSettings);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: {
      width: width !== null && width !== void 0 ? width : '100%'
    },
    "data-test-subj": "dataVisualizerDocumentCountChart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, loading ? /*#__PURE__*/_react.default.createElement(LoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      width: '100%',
      height: 120
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onBrushEnd: onBrushEnd,
    onElementClick: onElementClick,
    baseTheme: chartBaseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: value => xAxisFormatter.convert(value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: _charts.Position.Left,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    id: SPEC_ID,
    name: seriesName
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "time",
    yAccessors: ['value'],
    data: adjustedChartPoints,
    timeZone: timeZone,
    color: euiTheme.colors.vis.euiColorVis0,
    yNice: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  })));
};
exports.DocumentCountChart = DocumentCountChart;