"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsageMetricsDateRangePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _utils = require("../../../../common/utils");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_usage/public/app/components/filters/date_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UsageMetricsDateRangePicker = exports.UsageMetricsDateRangePicker = /*#__PURE__*/(0, _react.memo)(({
  dateRangePickerState,
  isDataLoading,
  onRefresh,
  onRefreshChange,
  onTimeChange,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const kibana = (0, _public.useKibana)();
  const {
    uiSettings
  } = kibana.services;
  const [commonlyUsedRanges] = (0, _react.useState)(() => {
    const _commonlyUsedRanges = uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
    if (!_commonlyUsedRanges) {
      return [];
    }
    return _commonlyUsedRanges.reduce((acc, {
      from,
      to,
      display
    }) => {
      if (!['now-30d/d', 'now-90d/d', 'now-1y/d'].includes(from)) {
        acc.push({
          start: from,
          end: to,
          label: display
        });
      }
      return acc;
    }, []);
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    "data-test-subj": getTestId('date-range'),
    isLoading: isDataLoading,
    dateFormat: 'MMM D, YYYY @ HH:mm',
    commonlyUsedRanges: commonlyUsedRanges,
    end: dateRangePickerState.endDate,
    isPaused: !dateRangePickerState.autoRefreshOptions.enabled,
    onTimeChange: onTimeChange,
    onRefreshChange: onRefreshChange,
    refreshInterval: dateRangePickerState.autoRefreshOptions.duration,
    onRefresh: onRefresh,
    recentlyUsedRanges: dateRangePickerState.recentlyUsedDateRanges,
    start: dateRangePickerState.startDate,
    showUpdateButton: false,
    timeFormat: 'HH:mm',
    updateButtonProps: {
      iconOnly: false,
      fill: false
    },
    utcOffset: 0,
    maxDate: (0, _utils.momentDateParser)(_utils.DEFAULT_DATE_RANGE_OPTIONS.maxDate),
    minDate: (0, _utils.momentDateParser)(_utils.DEFAULT_DATE_RANGE_OPTIONS.minDate),
    width: "auto",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  });
});
UsageMetricsDateRangePicker.displayName = 'UsageMetricsDateRangePicker';