"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chartKeyToTitleMap = exports.ChartPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _i18n = require("@kbn/i18n");
var _legend_action = require("./legend_action");
var _format_bytes = require("../../utils/format_bytes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_usage/public/app/components/chart_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove this when we have a title for each metric type

const chartKeyToTitleMap = exports.chartKeyToTitleMap = {
  ingest_rate: _i18n.i18n.translate('xpack.dataUsage.charts.ingestedMax', {
    defaultMessage: 'Data Ingested'
  }),
  storage_retained: _i18n.i18n.translate('xpack.dataUsage.charts.retainedMax', {
    defaultMessage: 'Data Retained in Storage'
  })
};
const ChartPanel = ({
  metricType,
  series,
  idx,
  popoverOpen,
  togglePopover
}) => {
  const baseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const chartTimestamps = series.flatMap(stream => stream.data.map(d => d.x));
  const [minTimestamp, maxTimestamp] = [Math.min(...chartTimestamps), Math.max(...chartTimestamps)];
  const tickFormat = (0, _react.useMemo)(() => (0, _charts.niceTimeFormatter)([minTimestamp, maxTimestamp]), [minTimestamp, maxTimestamp]);

  // Calculate the total for each time bucket
  const totalSeries = (0, _react.useMemo)(() => {
    const totalsMap = new Map();
    series.forEach(stream => {
      stream.data.forEach(point => {
        totalsMap.set(point.x, (totalsMap.get(point.x) || 0) + point.y);
      });
    });
    return Array.from(totalsMap.entries()).map(([x, y]) => ({
      x,
      y
    }));
  }, [series]);
  const renderLegendAction = (0, _react.useCallback)(({
    label
  }) => {
    if (label === 'Total') {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_legend_action.LegendAction, {
      label: label,
      idx: idx,
      popoverOpen: popoverOpen,
      togglePopover: togglePopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    });
  }, [idx, popoverOpen, togglePopover]);

  // Adjust tooltip items to ensure "Total" series is fully visible up to 8 series (the same number that fits in the side legend without scrolling)
  // For up to 8 series, add two extra tooltip lines (series.length + 2) so the "Total" entry isn't truncated.
  // If there are more than 8 series, cap the visible items to 9. Right click will be needed to see all.
  const maxVisibleTooltipItems = series.length <= 8 ? series.length + 2 : 9;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: metricType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    "data-test-subj": `${metricType}-chart`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, chartKeyToTitleMap[metricType] || metricType)), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 200
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    maxVisibleTooltipItems: maxVisibleTooltipItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: true,
    legendPosition: "right",
    xDomain: {
      min: minTimestamp,
      max: maxTimestamp
    },
    legendAction: renderLegendAction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: "Total",
    name: "Total",
    data: totalSeries
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    lineSeriesStyle: {
      line: {
        strokeWidth: 2
      },
      point: {
        visible: 'always',
        radius: 5
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }), series.map((stream, streamIdx) => /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    key: streamIdx,
    id: `${metricType}-${stream.name}`,
    name: stream.name,
    data: stream.data
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    stackAccessors: ['x'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: tickFormat,
    gridLine: {
      visible: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    gridLine: {
      visible: true
    },
    tickFormat: d => (0, _format_bytes.formatBytes)(d),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }))));
};
exports.ChartPanel = ChartPanel;