"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMarkdownAction = void 0;
var _i18n = require("@kbn/i18n");
var _presentationContainers = require("@kbn/presentation-containers");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _constants = require("./constants");
var _constants2 = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createMarkdownAction = () => ({
  id: _constants.ADD_MARKDOWN_ACTION_ID,
  grouping: [_public.ADD_PANEL_ANNOTATION_GROUP],
  order: 30,
  getIconType: () => 'visText',
  isCompatible: async ({
    embeddable
  }) => (0, _presentationContainers.apiCanAddNewPanel)(embeddable),
  execute: async ({
    embeddable
  }) => {
    if (!(0, _presentationContainers.apiCanAddNewPanel)(embeddable)) throw new _public2.IncompatibleActionError();
    const newMarkdownEmbeddable = await embeddable.addNewPanel({
      panelType: _constants2.MARKDOWN_EMBEDDABLE_TYPE,
      serializedState: {
        rawState: {
          content: ''
        }
      }
    }, true);
    return newMarkdownEmbeddable === null || newMarkdownEmbeddable === void 0 ? void 0 : newMarkdownEmbeddable.onEdit({
      isNewPanel: true
    });
  },
  getDisplayName: () => _i18n.i18n.translate('dashboardMarkdown.displayNameAriaLabel', {
    defaultMessage: 'Markdown text'
  }),
  getDisplayNameTooltip: () => _i18n.i18n.translate('dashboardMarkdown.tooltip', {
    defaultMessage: 'Add custom text to dashboards.'
  })
});
exports.createMarkdownAction = createMarkdownAction;