"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollectConfigContainer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _dashboard_drilldown_config = require("./dashboard_drilldown_config");
var _i18n = require("./i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dashboard_enhanced/public/services/drilldowns/abstract_dashboard_drilldown/components/collect_config_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const mergeDashboards = (dashboards, selectedDashboard) => {
  // if we have a selected dashboard and its not in the list, append it
  if (selectedDashboard && (0, _lodash.findIndex)(dashboards, {
    value: selectedDashboard.value
  }) === -1) {
    return [selectedDashboard, ...dashboards];
  }
  return dashboards;
};
const dashboardToMenuItem = (dashboardId, title) => ({
  value: dashboardId,
  label: title
});
class CollectConfigContainer extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "isMounted", true);
    (0, _defineProperty2.default)(this, "state", {
      dashboards: [],
      isLoading: false,
      searchString: undefined,
      selectedDashboard: undefined,
      error: undefined
    });
    (0, _defineProperty2.default)(this, "debouncedLoadDashboards", void 0);
    this.debouncedLoadDashboards = (0, _lodash.debounce)(this.loadDashboards.bind(this), 500);
  }
  componentDidMount() {
    this.loadSelectedDashboard();
    this.loadDashboards();
  }
  componentWillUnmount() {
    this.isMounted = false;
  }
  render() {
    const {
      config,
      onConfig
    } = this.props;
    const {
      dashboards,
      selectedDashboard,
      isLoading,
      error
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_dashboard_drilldown_config.DashboardDrilldownConfig, {
      dashboards: mergeDashboards(dashboards, selectedDashboard),
      isLoading: isLoading,
      error: error,
      onDashboardSelect: dashboardId => {
        onConfig({
          ...config,
          dashboardId
        });
        if (this.state.error) {
          this.setState({
            error: undefined
          });
        }
      },
      onSearchChange: this.debouncedLoadDashboards,
      config: config,
      onConfigChange: changes => {
        onConfig({
          ...config,
          ...changes
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    });
  }
  async loadSelectedDashboard() {
    const {
      config,
      params: {
        start
      }
    } = this.props;
    if (!config.dashboardId) return;
    const {
      dashboard
    } = await start().plugins;
    const findDashboardsService = await dashboard.findDashboardsService();
    const dashboardResponse = await findDashboardsService.findById(config.dashboardId);
    if (!this.isMounted) return;

    // handle case when destination dashboard no longer exists
    if (dashboardResponse.status === 'error' && dashboardResponse.notFound) {
      this.setState({
        error: (0, _i18n.txtDestinationDashboardNotFound)(config.dashboardId)
      });
      this.props.onConfig({
        ...config,
        dashboardId: undefined
      });
      return;
    }
    if (dashboardResponse.status === 'error') {
      this.setState({
        error: dashboardResponse.error.message
      });
      this.props.onConfig({
        ...config,
        dashboardId: undefined
      });
      return;
    }
    this.setState({
      selectedDashboard: dashboardToMenuItem(config.dashboardId, dashboardResponse.attributes.title)
    });
  }
  async loadDashboards(searchString) {
    this.setState({
      searchString,
      isLoading: true
    });
    const {
      dashboard
    } = this.props.params.start().plugins;
    const findDashboardsService = await dashboard.findDashboardsService();
    const results = await findDashboardsService.search({
      search: searchString !== null && searchString !== void 0 ? searchString : '',
      per_page: 100
    });

    // bail out if this response is no longer needed
    if (!this.isMounted) return;
    if (searchString !== this.state.searchString) return;
    const dashboardList = results.dashboards.map(({
      id,
      data
    }) => dashboardToMenuItem(id, data.title));
    this.setState({
      dashboards: dashboardList,
      isLoading: false
    });
  }
}
exports.CollectConfigContainer = CollectConfigContainer;