"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleRovingIndex = void 0;
var _get_focusable_elements = require("./get_focusable_elements");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Handles the roving index for a given element.
 *
 * @param ref - the ref to the element to handle the roving index.
 */
const handleRovingIndex = e => {
  var _elements$nextIndex;
  e.stopPropagation();
  const container = e.currentTarget;
  const elements = (0, _get_focusable_elements.getFocusableElements)(container);
  const currentIndex = elements.findIndex(el => el === document.activeElement);
  let nextIndex = currentIndex;
  switch (e.key) {
    case 'ArrowDown':
      e.preventDefault();
      nextIndex = (currentIndex + 1) % elements.length;
      break;
    case 'ArrowUp':
      e.preventDefault();
      nextIndex = (currentIndex - 1 + elements.length) % elements.length;
      break;
    case 'Home':
      e.preventDefault();
      nextIndex = 0;
      break;
    case 'End':
      e.preventDefault();
      nextIndex = elements.length - 1;
      break;
    default:
      return;
  }
  (_elements$nextIndex = elements[nextIndex]) === null || _elements$nextIndex === void 0 ? void 0 : _elements$nextIndex.focus();
};
exports.handleRovingIndex = handleRovingIndex;