"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridLayoutGlobalStyles = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
var _global_app_styles = require("../common/global_app_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout/layouts/grid/grid_global_app_style.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const globalLayoutStyles = euiTheme => (0, _react2.css)`
  :root {
    // TODO: these variables are legacy and we keep them for backward compatibility
    // https://github.com/elastic/kibana/issues/225264

    // there is no fixed header in the grid layout, so we want to set the offset to 0
    --euiFixedHeadersOffset: 0px;

    // height of the header banner
    --kbnHeaderBannerHeight: ${(0, _coreChromeLayoutConstants.layoutVar)('banner.height', '0px')};

    // the current total height of all app-area headers, this variable can be used for sticky headers offset relative to the top of the application area
    --kbnAppHeadersOffset: ${(0, _coreChromeLayoutConstants.layoutVar)('application.topBar.height', '0px')};

    // backward compatible way to position sticky sub-headers
    --kbn-application--sticky-headers-offset: ${(0, _coreChromeLayoutConstants.layoutVar)('application.topBar.height', '0px')};

    // height of the project header app action menu which is part of the application area
    --kbnProjectHeaderAppActionMenuHeight: ${(0, _coreChromeLayoutConstants.layoutVar)('application.topBar.height', '0px')};
  }

  // disable document-level scroll, since the application area handles it, but only when not printing
  @media screen {
    :root {
      overflow: hidden;
    }
  }

  #kibana-body {
    // DO NOT ADD ANY OVERFLOW BEHAVIORS HERE
    // It will break the sticky navigation
    min-height: 100%;
    display: flex;
    flex-direction: column;
  }

  // Affixes a div to restrict the position of charts tooltip to the visible viewport minus the header
  #${_coreChromeLayoutConstants.APP_FIXED_VIEWPORT_ID} {
    pointer-events: none;
    visibility: hidden;
    position: fixed;
    top: ${(0, _coreChromeLayoutConstants.layoutVar)('application.content.top', '0px')};
    right: ${(0, _coreChromeLayoutConstants.layoutVar)('application.content.right', '0px')};
    bottom: ${(0, _coreChromeLayoutConstants.layoutVar)('application.content.bottom', '0px')};
    left: ${(0, _coreChromeLayoutConstants.layoutVar)('application.content.left', '0px')};
  }

  .kbnAppWrapper {
    // DO NOT ADD ANY OTHER STYLES TO THIS SELECTOR
    // This a very nested dependency happening in "all" apps
    display: flex;
    flex-flow: column nowrap;
    flex-grow: 1;
    z-index: 0; // This effectively puts every high z-index inside the scope of this wrapper to it doesn't interfere with the header and/or overlay mask
    position: relative; // This is temporary for apps that relied on this being present on \`.application\`
  }

  // make data grid full screen mode respect the header banner
  #kibana-body .euiDataGrid--fullScreen {
    height: calc(100vh - var(--kbnHeaderBannerHeight));
    top: var(--kbnHeaderBannerHeight);
  }

  // make sure fixed bottom bars are positioned relative to the application area
  .euiBottomBar.euiBottomBar--fixed {
    left: ${(0, _coreChromeLayoutConstants.layoutVar)('application.left', '0px')} !important; /* override EUI inline style */
    right: ${(0, _coreChromeLayoutConstants.layoutVar)('application.right', '0px')} !important; /* override EUI inline style */
    bottom: ${(0, _coreChromeLayoutConstants.layoutVar)('application.bottom', '0px')} !important; /* override EUI inline style */
  }
`;

// temporary hacks that need to be removed after better flyout and global sidenav customization support in EUI
// https://github.com/elastic/eui/issues/8820
const globalTempHackStyles = euiTheme => (0, _react2.css)`
  // adjust position of the classic/project side-navigation
  .kbnBody .euiFlyout.euiCollapsibleNav {
    ${(0, _eui.logicalCSS)('top', (0, _coreChromeLayoutConstants.layoutVar)('application.top', '0px'))};
    ${(0, _eui.logicalCSS)('left', (0, _coreChromeLayoutConstants.layoutVar)('application.left', '0px'))};
    ${(0, _eui.logicalCSS)('bottom', (0, _coreChromeLayoutConstants.layoutVar)('application.bottom', '0px'))};
  }

  .kbnBody {
    // adjust position of all the right flyouts relative to the application area, except the ones that are "above the header"
    .euiFlyout[class*='right']:not(.euiOverlayMask[class*='aboveHeader'] .euiFlyout) {
      ${(0, _eui.logicalCSS)('top', (0, _coreChromeLayoutConstants.layoutVar)('application.top', '0px'))};
      ${(0, _eui.logicalCSS)('bottom', (0, _coreChromeLayoutConstants.layoutVar)('application.bottom', '0px'))};
      ${(0, _eui.logicalCSS)('right', (0, _coreChromeLayoutConstants.layoutVar)('application.right', '0px'))};
    }

    // overlay mask "belowHeader" should only cover the application area
    .euiOverlayMask[class*='belowHeader'] {
      ${(0, _eui.logicalCSS)('top', (0, _coreChromeLayoutConstants.layoutVar)('application.top', '0px'))};
      ${(0, _eui.logicalCSS)('left', (0, _coreChromeLayoutConstants.layoutVar)('application.left', '0px'))};
      ${(0, _eui.logicalCSS)('right', (0, _coreChromeLayoutConstants.layoutVar)('application.right', '0px'))};
      ${(0, _eui.logicalCSS)('bottom', (0, _coreChromeLayoutConstants.layoutVar)('application.bottom', '0px'))};
    }
  }

  // push flyout should be pushing the application area, instead of body
  #${_coreChromeLayoutConstants.APP_MAIN_SCROLL_CONTAINER_ID} {
    ${(0, _eui.logicalCSS)('padding-right', `var(--euiPushFlyoutOffsetInlineEnd, 0px)`)};
    ${(0, _eui.logicalCSS)('padding-left', `var(--euiPushFlyoutOffsetInlineStart, 0px)`)};
  }
  .kbnBody {
    // this is a temporary hack to override EUI's body padding with push flyout
    ${(0, _eui.logicalCSS)('padding-right', `0px !important`)};
    ${(0, _eui.logicalCSS)('padding-left', `0px !important`)};
    // this is a temporary hack to override EUI's body padding with euibottom bar
    ${(0, _eui.logicalCSS)('padding-bottom', `0px !important`)};
    // just for consistency with other sides
    ${(0, _eui.logicalCSS)('padding-top', `0px !important`)};
  }
`;
const GridLayoutGlobalStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: [globalLayoutStyles(euiTheme), globalTempHackStyles(euiTheme)],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_global_app_styles.CommonGlobalAppStyles, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }));
};
exports.GridLayoutGlobalStyles = GridLayoutGlobalStyles;