"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VULNERABILITY_GROUPING_OPTIONS = exports.VULNERABILITY_GROUPING_MULTIPLE_VALUE_FIELDS = exports.VULNERABILITY_FIELDS = exports.SESSION_STORAGE_FIELDS_MODAL_SHOW_SELECTED = exports.NO_FINDINGS_STATUS_REFRESH_INTERVAL_MS = exports.MIN_VERSION_GCP_CIS = exports.LOCAL_STORAGE_VULNERABILITIES_GROUPING_KEY = exports.LOCAL_STORAGE_PAGE_SIZE_RULES_KEY = exports.LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY = exports.LOCAL_STORAGE_NAMESPACE_KEY = exports.LOCAL_STORAGE_FINDINGS_LAST_SELECTED_TAB_KEY = exports.LOCAL_STORAGE_FINDINGS_GROUPING_KEY = exports.LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY = exports.LOCAL_STORAGE_DATA_TABLE_COLUMNS_KEY = exports.LOCAL_STORAGE_DASHBOARD_BENCHMARK_SORT_KEY = exports.LOCAL_STORAGE_3P_INTEGRATIONS_CALLOUT_KEY = exports.FINDINGS_GROUPING_OPTIONS = exports.FINDINGS_FILTER_OPTIONS = exports.FINDINGS_DOCS_URL = exports.EVENT_ID = exports.DETECTION_ENGINE_RULES_KEY = exports.DETECTION_ENGINE_ALERTS_KEY = exports.DEFAULT_VISIBLE_ROWS_PER_PAGE = exports.DEFAULT_NAMESPACE = exports.CDR_VULNERABILITY_GROUPING_RUNTIME_MAPPING_FIELDS = exports.CDR_VULNERABILITY_DATA_TABLE_RUNTIME_MAPPING_FIELDS = exports.CDR_MISCONFIGURATION_GROUPING_RUNTIME_MAPPING_FIELDS = exports.CDR_MISCONFIGURATION_DATA_TABLE_RUNTIME_MAPPING_FIELDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_VISIBLE_ROWS_PER_PAGE = exports.DEFAULT_VISIBLE_ROWS_PER_PAGE = 25;
const LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY = exports.LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY = 'cloudPosture:dataTable:pageSize';
const LOCAL_STORAGE_DATA_TABLE_COLUMNS_KEY = exports.LOCAL_STORAGE_DATA_TABLE_COLUMNS_KEY = 'cloudPosture:dataTable:columns';
const LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY = exports.LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY = 'cloudPosture:benchmark:pageSize';
const LOCAL_STORAGE_PAGE_SIZE_RULES_KEY = exports.LOCAL_STORAGE_PAGE_SIZE_RULES_KEY = 'cloudPosture:rules:pageSize';
const LOCAL_STORAGE_DASHBOARD_BENCHMARK_SORT_KEY = exports.LOCAL_STORAGE_DASHBOARD_BENCHMARK_SORT_KEY = 'cloudPosture:complianceDashboard:benchmarkSort';
const LOCAL_STORAGE_FINDINGS_LAST_SELECTED_TAB_KEY = exports.LOCAL_STORAGE_FINDINGS_LAST_SELECTED_TAB_KEY = 'cloudPosture:findings:lastSelectedTab';
const LOCAL_STORAGE_3P_INTEGRATIONS_CALLOUT_KEY = exports.LOCAL_STORAGE_3P_INTEGRATIONS_CALLOUT_KEY = 'cloudPosture:findings:3pIntegrationsCallout';
const LOCAL_STORAGE_VULNERABILITIES_GROUPING_KEY = exports.LOCAL_STORAGE_VULNERABILITIES_GROUPING_KEY = 'cspLatestVulnerabilitiesGrouping';
const LOCAL_STORAGE_FINDINGS_GROUPING_KEY = exports.LOCAL_STORAGE_FINDINGS_GROUPING_KEY = 'cspLatestFindingsGrouping';
const LOCAL_STORAGE_NAMESPACE_KEY = exports.LOCAL_STORAGE_NAMESPACE_KEY = 'cloudPosture:dashboard:namespace';
const SESSION_STORAGE_FIELDS_MODAL_SHOW_SELECTED = exports.SESSION_STORAGE_FIELDS_MODAL_SHOW_SELECTED = 'cloudPosture:fieldsModal:showSelected';
const DEFAULT_NAMESPACE = exports.DEFAULT_NAMESPACE = 'default';
const FINDINGS_DOCS_URL = exports.FINDINGS_DOCS_URL = 'https://ela.st/findings';
const MIN_VERSION_GCP_CIS = exports.MIN_VERSION_GCP_CIS = '1.5.2';
const NO_FINDINGS_STATUS_REFRESH_INTERVAL_MS = exports.NO_FINDINGS_STATUS_REFRESH_INTERVAL_MS = 10000;
const DETECTION_ENGINE_RULES_KEY = exports.DETECTION_ENGINE_RULES_KEY = 'detection_engine_rules';
const DETECTION_ENGINE_ALERTS_KEY = exports.DETECTION_ENGINE_ALERTS_KEY = 'detection_engine_alerts';
const FINDINGS_GROUPING_OPTIONS = exports.FINDINGS_GROUPING_OPTIONS = {
  NONE: 'none',
  RESOURCE_ID: 'resource.id',
  RESOURCE_NAME: 'resource.name',
  RULE_NAME: 'rule.name',
  RULE_SECTION: 'rule.section',
  CLOUD_ACCOUNT_NAME: 'cloud.account.name',
  CLOUD_ACCOUNT_ID: 'cloud.account.id',
  ORCHESTRATOR_CLUSTER_NAME: 'orchestrator.cluster.name',
  ORCHESTRATOR_CLUSTER_ID: 'orchestrator.cluster.id',
  NAMESPACE: 'data_stream.namespace'
};
const VULNERABILITY_FIELDS = exports.VULNERABILITY_FIELDS = {
  VULNERABILITY_TITLE: 'vulnerability.title',
  VULNERABILITY_ID: 'vulnerability.id',
  SCORE_BASE: 'vulnerability.score.base',
  RESOURCE_NAME: 'resource.name',
  RESOURCE_ID: 'resource.id',
  SEVERITY: 'vulnerability.severity',
  PACKAGE_NAME: 'package.name',
  PACKAGE_VERSION: 'package.version',
  PACKAGE_FIXED_VERSION: 'package.fixed_version',
  CLOUD_ACCOUNT_NAME: 'cloud.account.name',
  CLOUD_ACCOUNT_ID: 'cloud.account.id',
  CLOUD_PROVIDER: 'cloud.provider',
  DESCRIPTION: 'vulnerability.description',
  VENDOR: 'observer.vendor'
};
const VULNERABILITY_GROUPING_OPTIONS = exports.VULNERABILITY_GROUPING_OPTIONS = {
  NONE: 'none',
  RESOURCE_ID: VULNERABILITY_FIELDS.RESOURCE_ID,
  CLOUD_ACCOUNT_ID: VULNERABILITY_FIELDS.CLOUD_ACCOUNT_ID,
  CVE: VULNERABILITY_FIELDS.VULNERABILITY_ID
};
const FINDINGS_FILTER_OPTIONS = exports.FINDINGS_FILTER_OPTIONS = {
  CLOUD_PROVIDER: 'cloud.provider',
  NAMESPACE: 'data_stream.namespace',
  RULE_BENCHMARK_ID: 'rule.benchmark.id',
  RULE_BENCHMARK_POSTURE_TYPE: 'rule.benchmark.posture_type',
  RULE_BENCHMARK_VERSION: 'rule.benchmark.version',
  RESULT_EVALUATION: 'result.evaluation',
  RULE_SECTION: 'rule.section'
};

/*
 * ECS schema unique field to describe the event
 * https://www.elastic.co/guide/en/ecs/current/ecs-event.html
 */
const EVENT_ID = exports.EVENT_ID = 'event.id';
const VULNERABILITY_GROUPING_MULTIPLE_VALUE_FIELDS = exports.VULNERABILITY_GROUPING_MULTIPLE_VALUE_FIELDS = [VULNERABILITY_FIELDS.VULNERABILITY_ID, VULNERABILITY_FIELDS.PACKAGE_NAME, VULNERABILITY_FIELDS.PACKAGE_VERSION, VULNERABILITY_FIELDS.PACKAGE_FIXED_VERSION];

/*
The fields below are default columns of the Cloud Security Data Table that need to have keyword mapping.
The runtime mappings are used to prevent filtering out the data when any of these columns are sorted in the Data Table.
TODO: Remove the fields below once they are mapped as Keyword in the Third Party integrations, or remove
the fields from the runtime mappings if they are removed from the Data Table.
*/
const CDR_VULNERABILITY_DATA_TABLE_RUNTIME_MAPPING_FIELDS = exports.CDR_VULNERABILITY_DATA_TABLE_RUNTIME_MAPPING_FIELDS = [];
const CDR_MISCONFIGURATION_DATA_TABLE_RUNTIME_MAPPING_FIELDS = exports.CDR_MISCONFIGURATION_DATA_TABLE_RUNTIME_MAPPING_FIELDS = ['rule.benchmark.rule_number', 'rule.section', 'resource.sub_type'];

/*
The fields below are used to group the data in the Cloud Security Data Table.
The keys are the fields that are used to group the data, and the values are the fields that need to have keyword mapping
to prevent filtering out the data when grouping by the key field.
WARNING: only add keys which are not mapped as keywords - casting to keywords could have negative effect on performance.
TODO: Remove the fields below once they are mapped as Keyword in the Third Party integrations, or remove
the fields from the runtime mappings if they are removed from the Data Table.
*/
const CDR_VULNERABILITY_GROUPING_RUNTIME_MAPPING_FIELDS = exports.CDR_VULNERABILITY_GROUPING_RUNTIME_MAPPING_FIELDS = {};
const CDR_MISCONFIGURATION_GROUPING_RUNTIME_MAPPING_FIELDS = exports.CDR_MISCONFIGURATION_GROUPING_RUNTIME_MAPPING_FIELDS = {
  [FINDINGS_GROUPING_OPTIONS.ORCHESTRATOR_CLUSTER_ID]: ['orchestrator.cluster.id'],
  [FINDINGS_GROUPING_OPTIONS.CLOUD_ACCOUNT_ID]: ['cloud.account.id']
};