"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloudDefendPages = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kubernetes-security-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NAV_ITEMS_NAMES = {
  POLICIES: _i18n.i18n.translate('xpack.cloudDefend.navigation.policiesNavItemLabel', {
    defaultMessage: 'Container Workload Protection'
  })
};

/** The base path for all cloud defend pages. */
const CLOUD_DEFEND_BASE_PATH = '/cloud_defend';
const cloudDefendPages = exports.cloudDefendPages = {
  policies: {
    name: NAV_ITEMS_NAMES.POLICIES,
    path: `${CLOUD_DEFEND_BASE_PATH}/policies`,
    id: 'cloud_defend-policies'
  },
  dashboard: {
    name: _public.KUBERNETES_TITLE,
    path: _public.KUBERNETES_PATH,
    id: 'kubernetes_security-dashboard'
  }
};