"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelVersion6 = void 0;
var _schemas = require("../schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Adds the total_events field to the cases SO.
 */
const modelVersion6 = exports.modelVersion6 = {
  changes: [{
    type: 'mappings_addition',
    addedMappings: {
      total_events: {
        type: 'integer'
      }
    }
  }, {
    type: 'data_backfill',
    backfillFn: _doc => {
      return {
        attributes: {
          total_events: 0
        }
      };
    }
  }],
  schemas: {
    forwardCompatibility: _schemas.casesSchemaV6.extends({}, {
      unknowns: 'ignore'
    })
  }
};