"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.format = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapSeverity(severity) {
  switch (severity) {
    case 'low':
      return 1;
    case 'medium':
      return 2;
    case 'high':
      return 3;
    case 'critical':
      return 4;
    default:
      return 2;
  }
}
const format = theCase => {
  var _ref;
  const {
    tlp = null
  } = (_ref = theCase.connector.fields) !== null && _ref !== void 0 ? _ref : {};
  return {
    tags: theCase.tags,
    tlp,
    severity: mapSeverity(theCase.severity)
  };
};
exports.format = format;