"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindCasesContainingAllSelectedDocuments = void 0;
var _reactQuery = require("@kbn/react-query");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// deterministically create the same key for repeat requests
const normalizeQueryKey = (selectedAlertIds, caseIds) => [...new Set([...selectedAlertIds, ...caseIds])].sort();
const useFindCasesContainingAllSelectedDocuments = (selectedDocumentIds, caseIds) => {
  return (0, _reactQuery.useQuery)(normalizeQueryKey(selectedDocumentIds, caseIds), () => (0, _api.findCasesByAttachmentId)(selectedDocumentIds, caseIds), {
    enabled: selectedDocumentIds.length > 0 && caseIds.length > 0
  });
};
exports.useFindCasesContainingAllSelectedDocuments = useFindCasesContainingAllSelectedDocuments;