"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _domain = require("../../../../common/types/domain");
var _card = require("../card");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("./types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/thehive/case_fields_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mapTLP = tlpValue => {
  var _entry$;
  const entry = Object.entries(_types.TheHiveTLP).find(([_, value]) => value === tlpValue);
  return (_entry$ = entry === null || entry === void 0 ? void 0 : entry[0]) !== null && _entry$ !== void 0 ? _entry$ : 'AMBER';
};
const TheHiveFieldsPreviewComponent = ({
  fields,
  connector
}) => {
  const {
    tlp
  } = fields !== null && fields !== void 0 ? fields : {};
  const listItems = (0, _react.useMemo)(() => [...(tlp !== null ? [{
    title: i18n.TLP_LABEL,
    description: mapTLP(tlp)
  }] : [])], [tlp]);
  return /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _domain.ConnectorTypes.theHive,
    isLoading: false,
    listItems: listItems,
    title: connector.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
};
exports.default = TheHiveFieldsPreviewComponent;
TheHiveFieldsPreviewComponent.displayName = 'TheHiveFieldsPreview';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;