"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavButtons = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../links");
var _navigation = require("../../common/navigation");
var _use_cases_context = require("../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/nav_buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NavButtons = ({
  actionsErrors
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    getCreateCaseUrl,
    navigateToCreateCase
  } = (0, _navigation.useCreateCaseNavigation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const navigateToCreateCaseClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    navigateToCreateCase();
  }, [navigateToCreateCase]);
  if (!permissions.create && !permissions.settings) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    css: (0, _react2.css)`
          & {
            @media only screen and (max-width: ${euiTheme.breakpoint.s}) {
              flex-direction: column;
            }
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, permissions.settings && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_links.ConfigureCaseButton, {
    label: i18n.CONFIGURE_CASES_BUTTON,
    showToolTip: !(0, _fp.isEmpty)(actionsErrors),
    msgTooltip: !(0, _fp.isEmpty)(actionsErrors) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actionsErrors[0].description) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    titleTooltip: !(0, _fp.isEmpty)(actionsErrors) ? actionsErrors[0].title : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  })), permissions.create && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    fill: true,
    onClick: navigateToCreateCaseClick,
    href: getCreateCaseUrl(),
    iconType: "plusInCircle",
    "data-test-subj": "createNewCaseBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, i18n.CREATE_CASE_TITLE))));
};
exports.NavButtons = NavButtons;
NavButtons.displayName = 'NavButtons';