"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RefreshControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _elements = require("../../../state/actions/elements");
var _resolved_args = require("../../../state/selectors/resolved_args");
var _tool_tip_shortcut = require("../../tool_tip_shortcut");
var _use_canvas_api = require("../../hooks/use_canvas_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/refresh_control/refresh_control.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error untyped local
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getRefreshAriaLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderRefreshControlSettings.refreshAriaLabel', {
    defaultMessage: 'Refresh Elements'
  }),
  getRefreshTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderRefreshControlSettings.refreshTooltip', {
    defaultMessage: 'Refresh data'
  })
};
const RefreshControl = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const inFlight = (0, _reactRedux.useSelector)(_resolved_args.getInFlight);
  const doRefresh = (0, _react.useCallback)(() => {
    (0, _use_canvas_api.forceReload)();
    dispatch((0, _elements.fetchAllRenderables)());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }, strings.getRefreshTooltip(), /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
      namespace: "EDITOR",
      action: "REFRESH",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    disabled: inFlight,
    iconType: "refresh",
    "aria-label": strings.getRefreshAriaLabel(),
    onClick: doRefresh,
    "data-test-subj": "canvas-refresh-control",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
};
exports.RefreshControl = RefreshControl;
RefreshControl.propTypes = {
  doRefresh: _propTypes.default.func.isRequired,
  inFlight: _propTypes.default.bool
};