"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchLatencyOverallSpanDistribution = void 0;
var _create_call_apm_api = require("./create_call_apm_api");
var _latency_distribution_chart_types = require("../../../common/latency_distribution_chart_types");
var _environment_filter_values = require("../../../common/environment_filter_values");
var _constants = require("../../../common/correlations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchLatencyOverallSpanDistribution = ({
  spanName,
  serviceName,
  start,
  end,
  isOtel
}, signal) => (0, _create_call_apm_api.callApmApi)('POST /internal/apm/latency/overall_distribution/spans', {
  params: {
    body: {
      spanName,
      serviceName,
      start,
      end,
      chartType: _latency_distribution_chart_types.LatencyDistributionChartType.spanLatency,
      environment: _environment_filter_values.ENVIRONMENT_ALL_VALUE,
      kuery: '',
      percentileThreshold: _constants.DEFAULT_PERCENTILE_THRESHOLD,
      isOtel
    }
  },
  signal
});
exports.fetchLatencyOverallSpanDistribution = fetchLatencyOverallSpanDistribution;