"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyLatencyChart = DependencyLatencyChart;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_previous_period_text = require("../../../hooks/use_previous_period_text");
var _get_comparison_options = require("../time_comparison/get_comparison_options");
var _formatters = require("../../../../common/utils/formatters");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _timeseries_chart_with_context = require("../charts/timeseries_chart_with_context");
var _helper = require("../charts/transaction_charts/helper");
var _get_timeseries_color = require("../charts/helper/get_timeseries_color");
var _get_comparison_chart_theme = require("../time_comparison/get_comparison_chart_theme");
var _use_search_service_destination_metrics = require("../../../context/time_range_metadata/use_search_service_destination_metrics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/dependency_metric_charts/dependency_latency_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DependencyLatencyChart({
  height,
  dependencyName,
  rangeFrom,
  rangeTo,
  kuery,
  environment,
  offset,
  comparisonEnabled,
  spanName
}) {
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const {
    isTimeRangeMetadataLoading,
    searchServiceDestinationMetrics
  } = (0, _use_search_service_destination_metrics.useSearchServiceDestinationMetrics)({
    start,
    end,
    kuery
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (isTimeRangeMetadataLoading) {
      return;
    }
    return callApmApi('GET /internal/apm/dependencies/charts/latency', {
      params: {
        query: {
          dependencyName,
          start,
          end,
          offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined,
          kuery,
          environment,
          spanName: spanName || '',
          searchServiceDestinationMetrics
        }
      }
    });
  }, [dependencyName, start, end, offset, kuery, environment, comparisonEnabled, spanName, isTimeRangeMetadataLoading, searchServiceDestinationMetrics]);
  const {
    currentPeriodColor,
    previousPeriodColor
  } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_AVG);
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const timeseries = (0, _react.useMemo)(() => {
    const specs = [];
    if (data !== null && data !== void 0 && data.currentTimeseries) {
      specs.push({
        data: data.currentTimeseries,
        type: 'linemark',
        color: currentPeriodColor,
        title: _i18n.i18n.translate('xpack.apm.dependencyLatencyChart.chartTitle', {
          defaultMessage: 'Latency'
        })
      });
    }
    if (data !== null && data !== void 0 && data.comparisonTimeseries) {
      specs.push({
        data: data.comparisonTimeseries,
        type: 'area',
        color: previousPeriodColor,
        title: previousPeriodLabel
      });
    }
    return specs;
  }, [data, currentPeriodColor, previousPeriodColor, previousPeriodLabel]);
  const maxY = (0, _helper.getMaxY)(timeseries);
  const latencyFormatter = (0, _formatters.getDurationFormatter)(maxY);
  return /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    height: height,
    fetchStatus: status,
    id: "latencyChart",
    customTheme: comparisonChartTheme,
    timeseries: timeseries,
    yLabelFormat: (0, _helper.getResponseTimeTickFormatter)(latencyFormatter),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  });
}