"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiopsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("@kbn/aiops-common/constants");
var _constants2 = require("@kbn/aiops-log-rate-analysis/constants");
var _constants3 = require("@kbn/aiops-log-pattern-analysis/constants");
var _license = require("./lib/license");
var _define_route = require("./routes/log_rate_analysis_field_candidates/define_route");
var _define_route2 = require("./routes/log_rate_analysis/define_route");
var _define_route3 = require("./routes/categorization_field_validation/define_route");
var _register_cases = require("./register_cases");
var _capabilities = require("./lib/capabilities");
var _transform_in = require("../common/embeddables/log_rate_analysis/transform_in");
var _transform_out = require("../common/embeddables/log_rate_analysis/transform_out");
var _transform_in2 = require("../common/embeddables/pattern_analysis/transform_in");
var _transform_out2 = require("../common/embeddables/pattern_analysis/transform_out");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AiopsPlugin {
  constructor(initializerContext) {
    var _initializerContext$c, _initializerContext$c2;
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "licenseSubscription", null);
    (0, _defineProperty2.default)(this, "usageCounter", void 0);
    (0, _defineProperty2.default)(this, "aiopsEnabled", true);
    this.logger = initializerContext.logger.get();
    this.aiopsEnabled = (_initializerContext$c = (_initializerContext$c2 = initializerContext.config.get().ui) === null || _initializerContext$c2 === void 0 ? void 0 : _initializerContext$c2.enabled) !== null && _initializerContext$c !== void 0 ? _initializerContext$c : true;
  }
  setup(core, plugins) {
    var _plugins$usageCollect;
    (0, _capabilities.setupCapabilities)(core, this.aiopsEnabled);
    this.usageCounter = (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.createUsageCounter(_constants.AIOPS_PLUGIN_ID);

    // Subscribe to license changes and store the current license in `currentLicense`.
    // This way we can pass on license changes to the route factory having always
    // the current license because it's stored in a mutable attribute.
    const aiopsLicense = {
      isActivePlatinumLicense: false
    };
    this.licenseSubscription = plugins.licensing.license$.subscribe(license => {
      aiopsLicense.isActivePlatinumLicense = (0, _license.isActiveLicense)('platinum', license);
      if (aiopsLicense.isActivePlatinumLicense) {
        (0, _register_cases.registerCasesPersistableState)(plugins.cases, this.logger);
      }
    });
    const router = core.http.createRouter();

    // Register server side APIs
    void core.getStartServices().then(([coreStart, depsStart]) => {
      (0, _define_route.defineRoute)(router, aiopsLicense, coreStart, this.usageCounter);
      (0, _define_route2.defineRoute)(router, aiopsLicense, this.logger, coreStart, this.usageCounter);
      (0, _define_route3.defineRoute)(router, aiopsLicense, this.usageCounter);
    });
    plugins.embeddable.registerTransforms(_constants3.EMBEDDABLE_PATTERN_ANALYSIS_TYPE, {
      transformOutInjectsReferences: true,
      transformIn: _transform_in2.transformIn,
      transformOut: _transform_out2.transformOut
    });
    plugins.embeddable.registerTransforms(_constants2.EMBEDDABLE_LOG_RATE_ANALYSIS_TYPE, {
      transformOutInjectsReferences: true,
      transformIn: _transform_in.transformIn,
      transformOut: _transform_out.transformOut
    });
    return {};
  }
  start(core) {
    this.logger.debug('aiops: Started');
    return {};
  }
  stop() {
    var _this$licenseSubscrip;
    this.logger.debug('aiops: Stop');
    (_this$licenseSubscrip = this.licenseSubscription) === null || _this$licenseSubscrip === void 0 ? void 0 : _this$licenseSubscrip.unsubscribe();
  }
}
exports.AiopsPlugin = AiopsPlugin;