"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getComponents = void 0;
var _react = _interopRequireDefault(require("react"));
var _change_password_async = require("./change_password/change_password_async");
var _lazy_wrapper = require("./lazy_wrapper");
var _personal_info_async = require("./personal_info/personal_info_async");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/ui_api/components.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * We're importing specific files here instead of passing them
 * through the index file. It helps to keep the bundle size low.
 *
 * Importing async components through the index file increases the bundle size.
 * It happens because the bundle starts to also include all the sync dependencies
 * available through the index file.
 */
const getComponents = ({
  core
}) => {
  /**
   * Returns a function that creates a lazy-loading version of a component.
   */
  function wrapLazy(fn) {
    return props => /*#__PURE__*/_react.default.createElement(_lazy_wrapper.LazyWrapper, {
      fn: fn,
      core: core,
      props: props,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 7
      }
    });
  }
  return {
    getPersonalInfo: wrapLazy(_personal_info_async.getPersonalInfoComponent),
    getChangePassword: wrapLazy(() => (0, _change_password_async.getChangePasswordComponent)(core))
  };
};
exports.getComponents = getComponents;