"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JSONRuleEditor = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _monaco = require("@kbn/monaco");
var _model = require("../../model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/edit_role_mapping/rule_editor_panel/json_rule_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JSONRuleEditor = props => {
  const docLinks = (0, _public.useKibana)().services.docLinks;
  const [rawRules, setRawRules] = (0, _react.useState)(JSON.stringify(props.rules ? props.rules.toRaw() : {}, null, 2));
  const [ruleBuilderError, setRuleBuilderError] = (0, _react.useState)(null);
  function onRulesChange(updatedRules) {
    setRawRules(updatedRules);
    // Fire onChange only if rules are valid
    try {
      const ruleJSON = JSON.parse(updatedRules);
      props.onChange((0, _model.generateRulesFromRaw)(ruleJSON).rules);
      props.onValidityChange(true);
      setRuleBuilderError(null);
    } catch (e) {
      if (e instanceof _model.RuleBuilderError) {
        setRuleBuilderError(e);
      } else {
        setRuleBuilderError(null);
      }
      props.onValidityChange(false);
    }
  }
  function reformatRules() {
    try {
      const ruleJSON = JSON.parse(rawRules);
      setRawRules(JSON.stringify(ruleJSON, null, 2));
    } catch (ignore) {
      // ignore
    }
  }
  function conditionallyRenderReformatButton() {
    if (!props.readOnly) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "roleMappingsJSONReformatButton",
        iconType: "broom",
        onClick: reformatRules,
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.autoFormatRuleText",
        defaultMessage: "Reformat",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 11
        }
      }));
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: Boolean(ruleBuilderError),
    error: ruleBuilderError && _i18n.i18n.translate('xpack.security.management.editRoleMapping.JSONEditorRuleError', {
      defaultMessage: 'Invalid rule definition at {ruleLocation}: {errorMessage}',
      values: {
        ruleLocation: ruleBuilderError.ruleTrace.join('.'),
        errorMessage: ruleBuilderError.message
      }
    }),
    fullWidth: true,
    "data-test-subj": "roleMappingsJSONEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditorField, {
    "aria-label": '',
    languageId: _monaco.XJsonLang.ID,
    value: rawRules,
    onChange: onRulesChange,
    fullWidth: true,
    height: "300px",
    options: {
      accessibilitySupport: 'off',
      lineNumbers: 'on',
      fontSize: 12,
      tabSize: 2,
      automaticLayout: true,
      minimap: {
        enabled: false
      },
      overviewRulerBorder: false,
      scrollbar: {
        alwaysConsumeMouseWheel: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      readOnly: props.readOnly,
      domReadOnly: props.readOnly
      // ToDo: there does not appear to be a way to disable the read-only tooltip
      // Fortunately this only gets displayed when the 'delete' key is pressed.
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }), conditionallyRenderReformatButton(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRoleMapping.JSONEditorHelpText",
    defaultMessage: "Specify your rules in JSON format consistent with the {roleMappingAPI}",
    values: {
      roleMappingAPI: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.apis.createRoleMapping,
        external: true,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.JSONEditorEsApi",
        defaultMessage: "Elasticsearch role mapping API.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 21
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  })))));
};
exports.JSONRuleEditor = JSONRuleEditor;