"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoCompatibleRealms = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/components/no_compatible_realms/no_compatible_realms.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NoCompatibleRealms = () => {
  const docLinks = (0, _public.useKibana)().services.docLinks;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roleMappings.noCompatibleRealmsErrorTitle",
      defaultMessage: "No compatible realms appear to be enabled in Elasticsearch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 19,
        columnNumber: 9
      }
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.roleMappings.noCompatibleRealmsErrorDescription",
    defaultMessage: "Role mappings may not be applied to users. Contact your system administrator and refer to the {link} for more information.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.security.mappingRoles,
        external: true,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.roleMappings.noCompatibleRealmsErrorLinkText",
        defaultMessage: "docs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 33,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }));
};
exports.NoCompatibleRealms = NoCompatibleRealms;