"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/error_prompt/error_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ERROR_MESSAGES = {
  notFound: {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.queryRules.notFoundTitle",
      defaultMessage: "Not found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 17,
        columnNumber: 12
      }
    }),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.queryRuleset.notFoundDescription",
      defaultMessage: "Requested resource was not found. Check if the URL is correct.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 19,
        columnNumber: 7
      }
    }),
    analyticsEvent: _constants.AnalyticsEvents.notFoundErrorPromptLoaded
  },
  generic: {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.queryRules.errorTitle",
      defaultMessage: "An error occurred",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 12
      }
    }),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.queryRules.errorDescription",
      defaultMessage: "An error occurred while fetching query rules. Check Kibana logs for more information.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 7
      }
    }),
    analyticsEvent: _constants.AnalyticsEvents.genericErrorPromptLoaded
  },
  missingPermissions: {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.queryRules.missingPermissionsTitle",
      defaultMessage: "Missing permissions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    }),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.queryRules.missingPermissionsDescription",
      defaultMessage: "You do not have the necessary permissions to manage query rules. Contact your system administrator.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 7
      }
    }),
    analyticsEvent: _constants.AnalyticsEvents.missingPermissionsErrorPromptLoaded
  }
};
const ErrorPrompt = ({
  errorType
}) => {
  const useTracker = (0, _use_usage_tracker.useUsageTracker)();
  (0, _react.useEffect)(() => {
    var _useTracker$load;
    useTracker === null || useTracker === void 0 ? void 0 : (_useTracker$load = useTracker.load) === null || _useTracker$load === void 0 ? void 0 : _useTracker$load.call(useTracker, ERROR_MESSAGES[errorType].analyticsEvent);
  }, [errorType, useTracker]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "logoElasticsearch",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 14
      }
    }, ERROR_MESSAGES[errorType].title),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }, ERROR_MESSAGES[errorType].body),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  });
};
exports.ErrorPrompt = ErrorPrompt;