"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JavascriptSearchExample = exports.JavascriptCreateIndexExamples = exports.JSSemanticIngestDataExample = exports.JSIngestDataExample = exports.JAVASCRIPT_INFO = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JAVASCRIPT_INFO = exports.JAVASCRIPT_INFO = {
  id: 'javascript',
  title: _i18n.i18n.translate('xpack.searchIndices.codingLanguages.javascript', {
    defaultMessage: 'Javascript'
  }),
  icon: 'javascript.svg',
  codeBlockLanguage: 'javascript'
};
const INSTALL_CMD = `npm install @elastic/elasticsearch`;
const CLIENT_SERVERLESS_OPTION = `\n  serverMode: 'serverless',`;
const createClientSnippet = ({
  apiKey,
  elasticsearchURL,
  isServerless
}) => `const client = new Client({
  node: '${elasticsearchURL}',
  auth: {
    apiKey: '${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}'
  },${isServerless ? CLIENT_SERVERLESS_OPTION : ''}
});`;
const JavascriptCreateIndexExamples = exports.JavascriptCreateIndexExamples = {
  default: {
    installCommand: INSTALL_CMD,
    createIndex: args => {
      var _args$indexName;
      return `const { Client } = require('@elastic/elasticsearch');

${createClientSnippet(args)}

const createResponse = await client.indices.create({
  index: '${(_args$indexName = args.indexName) !== null && _args$indexName !== void 0 ? _args$indexName : _constants.INDEX_PLACEHOLDER}',
  mappings: {
    properties: {
      text: { type: 'text'}
    },
  });
}
console.log(createResponse);`;
    }
  },
  dense_vector: {
    installCommand: INSTALL_CMD,
    createIndex: args => {
      var _args$indexName2;
      return `const { Client } = require('@elastic/elasticsearch');

${createClientSnippet(args)}

const createResponse = await client.indices.create({
  index: '${(_args$indexName2 = args.indexName) !== null && _args$indexName2 !== void 0 ? _args$indexName2 : _constants.INDEX_PLACEHOLDER}',
  mappings: {
    properties: {
      vector: { type: 'dense_vector', dims: 3 },
      text: { type: 'text'}
    },
  });
}
console.log(createResponse);`;
    }
  },
  semantic: {
    installCommand: INSTALL_CMD,
    createIndex: args => {
      var _args$indexName3;
      return `const { Client } = require('@elastic/elasticsearch');

${createClientSnippet(args)}

const createResponse = client.indices.create({
  index: '${(_args$indexName3 = args.indexName) !== null && _args$indexName3 !== void 0 ? _args$indexName3 : _constants.INDEX_PLACEHOLDER}',
  mappings: {
    properties: {
      text: { type: 'semantic_text'}
    },
  });
}
console.log(createResponse);`;
    }
  }
};
const JSIngestDataExample = exports.JSIngestDataExample = {
  installCommand: INSTALL_CMD,
  ingestCommand: args => `const { Client } = require('@elastic/elasticsearch');

${createClientSnippet(args)}

const index = '${args.indexName}';
const docs = ${JSON.stringify(args.sampleDocuments, null, 2)};

const bulkIngestResponse = await client.helpers.bulk({
  index,
  datasource: docs,
  onDocument() {
    return {
      index: {},
    };
  }
});
console.log(bulkIngestResponse);`,
  updateMappingsCommand: args => `const { Client } = require('@elastic/elasticsearch');

${createClientSnippet(args)}

const index = '${args.indexName}';
const mapping = ${JSON.stringify(args.mappingProperties, null, 2)};

const updateMappingResponse = await client.indices.putMapping({
  index,
  properties: mapping,
});
console.log(updateMappingResponse);`
};
const searchCommand = args => `import { Client } from '@elastic/elasticsearch';

${createClientSnippet(args)}

const index = '${args.indexName}';
const body = ${JSON.stringify(args.queryObject, null, 2)};

const result = await client.search({
  index,
  body,
});

console.log(result.hits.hits);`;
const JavascriptSearchExample = exports.JavascriptSearchExample = {
  searchCommand
};
const JSSemanticIngestDataExample = exports.JSSemanticIngestDataExample = {
  ...JSIngestDataExample,
  ingestCommand: args => `const { Client } = require('@elastic/elasticsearch');

${createClientSnippet(args)}

// Timeout to allow machine learning model loading and semantic ingestion to complete
const timeout = '5m';

const index = '${args.indexName}';
const docs = ${JSON.stringify(args.sampleDocuments, null, 2)};

const bulkIngestResponse = await client.helpers.bulk({
  index,
  datasource: docs,
  timeout,
  onDocument() {
    return {
      index: {},
    };
  }
});

console.log(bulkIngestResponse);`
};